/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.planning;

import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.SequencerType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Sequence<T>
implements OpSequence<T> {
    private final SequencerType type;
    private final List<T> elems;
    private final int[] seq;

    Sequence(SequencerType type, List<T> elems, int[] seq) {
        this.type = type;
        this.elems = elems;
        this.seq = seq;
    }

    @Override
    public T apply(long selector) {
        int index = (int)(selector % (long)this.seq.length);
        index = this.seq[index];
        return this.elems.get(index);
    }

    @Override
    public List<T> getOps() {
        return this.elems;
    }

    @Override
    public int[] getSequence() {
        return this.seq;
    }

    public SequencerType getSequencerType() {
        return this.type;
    }

    @Override
    public <U> Sequence<U> transform(Function<T, U> func) {
        return new Sequence(this.type, this.elems.stream().map(func).collect(Collectors.toList()), this.seq);
    }

    public String toString() {
        return Arrays.toString(this.seq);
    }
}

