/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.planning;

import io.nosqlbench.engine.api.activityapi.planning.BucketSequencer;
import io.nosqlbench.engine.api.activityapi.planning.ConcatSequencer;
import io.nosqlbench.engine.api.activityapi.planning.IntervalSequencer;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.Sequence;
import io.nosqlbench.engine.api.activityapi.planning.SequencerType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToLongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SequencePlanner<T> {
    private static final Logger logger = LogManager.getLogger(SequencePlanner.class);
    private final SequencerType sequencerType;
    private final List<T> elements = new ArrayList<T>();
    private final List<Long> ratios = new ArrayList<Long>();
    private int[] elementIndex;

    public SequencePlanner(SequencerType sequencerType) {
        this.sequencerType = sequencerType;
    }

    public void addOp(T elem, ToLongFunction<T> ratioFunc) {
        this.elements.add(elem);
        this.ratios.add(ratioFunc.applyAsLong(elem));
    }

    public void addOp(T elem, long func) {
        this.elements.add(elem);
        this.ratios.add(func);
    }

    public OpSequence<T> resolve() {
        switch (this.sequencerType) {
            case bucket: {
                logger.trace("sequencing elements by simple round-robin");
                this.elementIndex = new BucketSequencer<T>().seqIndexesByRatios(this.elements, this.ratios);
                break;
            }
            case interval: {
                logger.trace("sequencing elements by interval and position");
                this.elementIndex = new IntervalSequencer<T>().seqIndexesByRatios(this.elements, this.ratios);
                break;
            }
            case concat: {
                logger.trace("sequencing elements by concatenation");
                this.elementIndex = new ConcatSequencer<T>().seqIndexesByRatios(this.elements, this.ratios);
            }
        }
        return new Sequence<T>(this.sequencerType, this.elements, this.elementIndex);
    }

    public List<T> getElements() {
        return this.elements;
    }

    public List<Long> getRatios() {
        return this.ratios;
    }
}

