/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.ratelimits;

import com.codahale.metrics.Gauge;
import io.nosqlbench.engine.api.activityapi.core.Startable;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiter;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiters;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateSpec;
import io.nosqlbench.engine.api.activityapi.ratelimits.ThreadDrivenTokenPool;
import io.nosqlbench.engine.api.activityapi.ratelimits.TokenPool;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.nb.annotations.Service;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Service(value=RateLimiter.class, selector="hybrid")
public class HybridRateLimiter
implements Startable,
RateLimiter {
    private static final Logger logger = LogManager.getLogger(HybridRateLimiter.class);
    private volatile long starttime;
    private RateSpec rateSpec;
    private ActivityDef activityDef;
    private String label;
    private State state = State.Idle;
    private Gauge<Long> delayGauge;
    private Gauge<Double> avgRateGauge;
    private Gauge<Double> burstRateGauge;
    private TokenPool tokens;
    private final AtomicLong cumulativeWaitTimeNanos = new AtomicLong(0L);

    protected HybridRateLimiter() {
    }

    public HybridRateLimiter(ActivityDef def, String label, RateSpec rateSpec) {
        this.setActivityDef(def);
        this.setLabel(label);
        this.init(this.activityDef);
        this.applyRateSpec(rateSpec);
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setActivityDef(ActivityDef def) {
        this.activityDef = def;
    }

    @Override
    public long maybeWaitForOp() {
        return this.tokens.blockAndTake();
    }

    @Override
    public long getTotalWaitTime() {
        return this.cumulativeWaitTimeNanos.get() + this.getWaitTime();
    }

    @Override
    public long getWaitTime() {
        return this.tokens.getWaitTime();
    }

    @Override
    public RateSpec getRateSpec() {
        return this.rateSpec;
    }

    @Override
    public synchronized void applyRateSpec(RateSpec updatingRateSpec) {
        if (updatingRateSpec == null) {
            throw new RuntimeException("RateSpec must be defined");
        }
        if (updatingRateSpec.equals(this.rateSpec) && !updatingRateSpec.isRestart()) {
            return;
        }
        this.rateSpec = updatingRateSpec;
        TokenPool tokenPool = this.tokens = this.tokens == null ? new ThreadDrivenTokenPool(this.rateSpec, this.activityDef) : this.tokens.apply(this.rateSpec);
        if (this.state == State.Idle && updatingRateSpec.isAutoStart()) {
            this.start();
        } else if (updatingRateSpec.isRestart()) {
            this.restart();
        }
    }

    protected void init(ActivityDef activityDef) {
        this.delayGauge = ActivityMetrics.gauge((ActivityDef)activityDef, (String)(this.label + ".waittime"), (Gauge)new RateLimiters.WaitTimeGauge(this));
        this.avgRateGauge = ActivityMetrics.gauge((ActivityDef)activityDef, (String)(this.label + ".config.cyclerate"), (Gauge)new RateLimiters.RateGauge(this));
        this.burstRateGauge = ActivityMetrics.gauge((ActivityDef)activityDef, (String)(this.label + ".config.burstrate"), (Gauge)new RateLimiters.BurstRateGauge(this));
    }

    @Override
    public synchronized void start() {
        switch (this.state) {
            case Started: 
            case Idle: {
                long nanos;
                this.starttime = nanos = this.getNanoClockTime();
                this.tokens.start();
                this.state = State.Started;
            }
        }
    }

    public synchronized long restart() {
        switch (this.state) {
            case Idle: {
                this.start();
                return 0L;
            }
            case Started: {
                long accumulatedWaitSinceLastStart = this.cumulativeWaitTimeNanos.get();
                this.cumulativeWaitTimeNanos.set(0L);
                return this.tokens.restart() + accumulatedWaitSinceLastStart;
            }
        }
        return 0L;
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    private synchronized void checkpointCumulativeWaitTime() {
        long nanos;
        this.starttime = nanos = this.getNanoClockTime();
        this.cumulativeWaitTimeNanos.addAndGet(this.getWaitTime());
    }

    protected long getNanoClockTime() {
        return System.nanoTime();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(HybridRateLimiter.class.getSimpleName());
        sb.append("{\n");
        if (this.getRateSpec() != null) {
            sb.append("      spec:").append(this.getRateSpec().toString());
        }
        if (this.tokens != null) {
            sb.append(",\n tokenpool:").append(this.tokens.toString());
        }
        if (this.state != null) {
            sb.append(",\n     state:'").append((Object)this.state).append("'");
        }
        sb.append("\n}");
        return sb.toString();
    }

    private static enum State {
        Idle,
        Started;

    }

    private class PoolGauge
    implements Gauge<Long> {
        private final HybridRateLimiter rl;

        public PoolGauge(HybridRateLimiter hybridRateLimiter2) {
            this.rl = hybridRateLimiter2;
        }

        public Long getValue() {
            TokenPool pool = this.rl.tokens;
            if (pool == null) {
                return 0L;
            }
            return pool.getWaitTime();
        }
    }
}

