/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.ratelimits;

import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateSpec;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.api.util.Colors;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InlineTokenPool {
    private static final Logger logger = LogManager.getLogger(InlineTokenPool.class);
    public static final double MIN_CONCURRENT_OPS = 5.0;
    private long maxActivePoolSize;
    private long maxBurstPoolSize;
    private long maxActiveAndBurstSize;
    private double burstRatio;
    private volatile long activePool;
    private volatile long waitingPool;
    private long nanosPerOp;
    private volatile long lastRefillAt;
    private final Timer refillTimer;
    private final long interval = 1000000L;
    private RateSpec rateSpec;
    private long blocks = 0L;
    private final Lock lock = new ReentrantLock();
    private final Condition lockheld = this.lock.newCondition();

    public InlineTokenPool(RateSpec rateSpec, ActivityDef def) {
        ByteBuffer logbuf = this.getBuffer();
        this.apply(rateSpec);
        logger.debug("initialized token pool: " + this.toString() + " for rate:" + rateSpec.toString());
        this.refillTimer = ActivityMetrics.timer((ActivityDef)def, (String)"tokenfiller");
    }

    public InlineTokenPool(long poolsize, double burstRatio, ActivityDef def) {
        ByteBuffer logbuf = this.getBuffer();
        this.maxActivePoolSize = poolsize;
        this.burstRatio = burstRatio;
        this.maxActiveAndBurstSize = (long)((double)this.maxActivePoolSize * burstRatio);
        this.maxBurstPoolSize = this.maxActiveAndBurstSize - this.maxActivePoolSize;
        this.refillTimer = ActivityMetrics.timer((ActivityDef)def, (String)"tokenfiller");
    }

    public synchronized void apply(RateSpec rateSpec) {
        this.rateSpec = rateSpec;
        this.maxActivePoolSize = Math.max(1000000L, (long)((double)rateSpec.getNanosPerOp() * 5.0));
        this.maxActiveAndBurstSize = (long)((double)this.maxActivePoolSize * rateSpec.getBurstRatio());
        this.burstRatio = rateSpec.getBurstRatio();
        this.maxBurstPoolSize = this.maxActiveAndBurstSize - this.maxActivePoolSize;
        this.nanosPerOp = rateSpec.getNanosPerOp();
        this.notifyAll();
    }

    public double getBurstRatio() {
        return this.burstRatio;
    }

    public synchronized long takeUpTo(long amt) {
        long take = Math.min(amt, this.activePool);
        this.activePool -= take;
        return take;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long blockAndTake() {
        InlineTokenPool inlineTokenPool = this;
        synchronized (inlineTokenPool) {
            if (this.activePool >= this.nanosPerOp) {
                this.activePool -= this.nanosPerOp;
                return this.waitingPool + this.activePool;
            }
        }
        while (true) {
            if (this.lock.tryLock()) {
                try {
                    while (this.activePool < this.nanosPerOp) {
                        this.dorefill();
                    }
                    this.lockheld.signal();
                    this.lockheld.signal();
                }
                finally {
                    this.lock.unlock();
                }
                continue;
            }
            try {
                this.lockheld.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized long blockAndTakeOps(long ops) {
        long totalNanosNeeded = ops * this.nanosPerOp;
        while (this.activePool < totalNanosNeeded) {
            ++this.blocks;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.activePool -= totalNanosNeeded;
        return this.waitingPool + this.activePool;
    }

    public synchronized long blockAndTake(long tokens) {
        while (this.activePool < tokens) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.activePool -= tokens;
        return this.waitingPool + this.activePool;
    }

    public long getWaitTime() {
        return this.activePool + this.waitingPool;
    }

    public long getWaitPool() {
        return this.waitingPool;
    }

    public long getActivePool() {
        return this.activePool;
    }

    public synchronized long refill(long newTokens) {
        boolean debugthis = false;
        long needed = Math.max(this.maxActivePoolSize - this.activePool, 0L);
        long allocatedToActivePool = Math.min(newTokens, needed);
        this.activePool += allocatedToActivePool;
        long allocatedToOverflowPool = newTokens - allocatedToActivePool;
        this.waitingPool += allocatedToOverflowPool;
        double refillFactor = Math.min((double)newTokens / (double)this.maxActivePoolSize, 1.0);
        long burstFillAllowed = (long)(refillFactor * (double)this.maxBurstPoolSize);
        burstFillAllowed = Math.min(this.maxActiveAndBurstSize - this.activePool, burstFillAllowed);
        long burstFill = Math.min(burstFillAllowed, this.waitingPool);
        this.waitingPool -= burstFill;
        this.activePool += burstFill;
        if (debugthis) {
            System.out.print(this);
            System.out.print(Colors.ANSI_BrightBlue + " adding=" + allocatedToActivePool);
            if (allocatedToOverflowPool > 0L) {
                System.out.print(Colors.ANSI_Red + " OVERFLOW:" + allocatedToOverflowPool + Colors.ANSI_Reset);
            }
            if (burstFill > 0L) {
                System.out.print(Colors.ANSI_BrightGreen + " BACKFILL:" + burstFill + Colors.ANSI_Reset);
            }
            System.out.println();
        }
        this.notifyAll();
        return this.activePool + this.waitingPool;
    }

    public String toString() {
        return "Tokens: active=" + this.activePool + "/" + this.maxActivePoolSize + String.format(" (%3.1f%%)A (%3.1f%%)B ", (double)this.activePool / (double)this.maxActivePoolSize * 100.0, (double)this.activePool / (double)this.maxActiveAndBurstSize * 100.0) + " waiting=" + this.waitingPool + " blocks=" + this.blocks + " rateSpec:" + (this.rateSpec != null ? this.rateSpec.toString() : "NULL");
    }

    public RateSpec getRateSpec() {
        return this.rateSpec;
    }

    public synchronized long restart() {
        long wait = this.activePool + this.waitingPool;
        this.activePool = 0L;
        this.waitingPool = 0L;
        return wait;
    }

    private ByteBuffer getBuffer() {
        RandomAccessFile image = null;
        try {
            image = new RandomAccessFile("tokenbucket.binlog", "rw");
            MappedByteBuffer mbb = image.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, image.length());
            return mbb;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void dorefill() {
        this.lastRefillAt = System.nanoTime();
        long nextRefillTime = this.lastRefillAt + 1000000L;
        long thisRefillTime = System.nanoTime();
        while (thisRefillTime < nextRefillTime) {
            long parkfor = Math.max(nextRefillTime - thisRefillTime, 0L);
            LockSupport.parkNanos(parkfor);
            thisRefillTime = System.nanoTime();
        }
        long delta = thisRefillTime - this.lastRefillAt;
        this.lastRefillAt = thisRefillTime;
        this.refill(delta);
        this.refillTimer.update(delta, TimeUnit.NANOSECONDS);
    }
}

