/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.ratelimits;

import com.codahale.metrics.Gauge;
import io.nosqlbench.engine.api.activityapi.ratelimits.HybridRateLimiter;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiter;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateSpec;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RateLimiters {
    private static final Logger logger = LogManager.getLogger(RateLimiters.class);

    public static synchronized RateLimiter createOrUpdate(ActivityDef def, String label, RateLimiter extant, RateSpec spec) {
        if (extant == null) {
            HybridRateLimiter rateLimiter = new HybridRateLimiter(def, label, spec);
            logger.info("Using rate limiter: " + ((Object)rateLimiter).toString());
            return rateLimiter;
        }
        extant.applyRateSpec(spec);
        logger.info("Updated rate limiter: " + extant.toString());
        return extant;
    }

    public static synchronized RateLimiter create(ActivityDef def, String label, String specString) {
        return RateLimiters.createOrUpdate(def, label, null, new RateSpec(specString));
    }

    public static class BurstRateGauge
    implements Gauge<Double> {
        private final RateLimiter rateLimiter;

        public BurstRateGauge(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }

        public Double getValue() {
            return this.rateLimiter.getRateSpec().getBurstRatio() * this.rateLimiter.getRateSpec().getRate();
        }
    }

    public static class RateGauge
    implements Gauge<Double> {
        private final RateLimiter rateLimiter;

        public RateGauge(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }

        public Double getValue() {
            return this.rateLimiter.getRateSpec().opsPerSec;
        }
    }

    public static class WaitTimeGauge
    implements Gauge<Long> {
        private final RateLimiter rateLimiter;

        public WaitTimeGauge(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }

        public Long getValue() {
            return this.rateLimiter.getTotalWaitTime();
        }
    }
}

