/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityapi.ratelimits;

import io.nosqlbench.engine.api.activityapi.ratelimits.RateSpec;
import io.nosqlbench.engine.api.activityapi.ratelimits.TokenFiller;
import io.nosqlbench.engine.api.activityapi.ratelimits.TokenPool;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.util.Colors;
import io.nosqlbench.nb.annotations.Service;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Service(value=TokenPool.class, selector="threaded")
public class ThreadDrivenTokenPool
implements TokenPool {
    private static final Logger logger = LogManager.getLogger(ThreadDrivenTokenPool.class);
    public static final double MIN_CONCURRENT_OPS = 2.0;
    private long maxActivePool;
    private long burstPoolSize;
    private long maxOverActivePool;
    private double burstRatio;
    private volatile long activePool;
    private volatile long waitingPool;
    private RateSpec rateSpec;
    private long nanosPerOp;
    private long blocks = 0L;
    private TokenFiller filler;
    private final ActivityDef activityDef;

    public ThreadDrivenTokenPool(RateSpec rateSpec, ActivityDef activityDef) {
        this.activityDef = activityDef;
        this.apply(rateSpec);
        logger.debug("initialized token pool: " + this + " for rate:" + rateSpec);
    }

    @Override
    public synchronized TokenPool apply(RateSpec rateSpec) {
        this.rateSpec = rateSpec;
        this.maxActivePool = Math.max(1000000L, (long)((double)rateSpec.getNanosPerOp() * 2.0));
        this.maxOverActivePool = (long)((double)this.maxActivePool * rateSpec.getBurstRatio());
        this.burstRatio = rateSpec.getBurstRatio();
        this.burstPoolSize = this.maxOverActivePool - this.maxActivePool;
        this.nanosPerOp = rateSpec.getNanosPerOp();
        this.filler = this.filler == null ? new TokenFiller(rateSpec, this, this.activityDef) : this.filler.apply(rateSpec);
        this.notifyAll();
        return this;
    }

    @Override
    public double getBurstRatio() {
        return this.burstRatio;
    }

    @Override
    public synchronized long takeUpTo(long amt) {
        long take = Math.min(amt, this.activePool);
        this.activePool -= take;
        return take;
    }

    @Override
    public synchronized long blockAndTake() {
        while (this.activePool < this.nanosPerOp) {
            ++this.blocks;
            try {
                this.wait(this.maxActivePool / 1000000L, 0);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.activePool -= this.nanosPerOp;
        return this.waitingPool + this.activePool;
    }

    @Override
    public synchronized long blockAndTake(long tokens) {
        while (this.activePool < tokens) {
            try {
                this.wait(this.maxActivePool / 1000000L, (int)this.maxActivePool % 1000000);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.activePool -= tokens;
        return this.waitingPool + this.activePool;
    }

    @Override
    public long getWaitTime() {
        return this.activePool + this.waitingPool;
    }

    @Override
    public long getWaitPool() {
        return this.waitingPool;
    }

    @Override
    public long getActivePool() {
        return this.activePool;
    }

    public synchronized long refill(long newTokens) {
        boolean debugthis = false;
        long needed = Math.max(this.maxActivePool - this.activePool, 0L);
        long allocatedToActivePool = Math.min(newTokens, needed);
        this.activePool += allocatedToActivePool;
        long allocatedToOverflowPool = newTokens - allocatedToActivePool;
        this.waitingPool += allocatedToOverflowPool;
        double refillFactor = Math.min((double)newTokens / (double)this.maxActivePool, 1.0);
        long burstFillAllowed = (long)(refillFactor * (double)this.burstPoolSize);
        burstFillAllowed = Math.min(this.maxOverActivePool - this.activePool, burstFillAllowed);
        long burstFill = Math.min(burstFillAllowed, this.waitingPool);
        this.waitingPool -= burstFill;
        this.activePool += burstFill;
        if (debugthis) {
            System.out.print(this);
            System.out.print(Colors.ANSI_BrightBlue + " adding=" + allocatedToActivePool);
            if (allocatedToOverflowPool > 0L) {
                System.out.print(Colors.ANSI_Red + " OVERFLOW:" + allocatedToOverflowPool + Colors.ANSI_Reset);
            }
            if (burstFill > 0L) {
                System.out.print(Colors.ANSI_BrightGreen + " BACKFILL:" + burstFill + Colors.ANSI_Reset);
            }
            System.out.println();
        }
        this.notifyAll();
        return this.activePool + this.waitingPool;
    }

    public String toString() {
        return String.format("{ active:%d, max:%d, fill:'(%,3.1f%%)A (%,3.1f%%)B', wait_ns:%,d, blocks:%,d }", this.activePool, this.maxActivePool, (double)this.activePool / (double)this.maxActivePool * 100.0, (double)this.activePool / (double)this.maxOverActivePool * 100.0, this.waitingPool, this.blocks);
    }

    @Override
    public RateSpec getRateSpec() {
        return this.rateSpec;
    }

    @Override
    public synchronized long restart() {
        long wait = this.activePool + this.waitingPool;
        this.activePool = 0L;
        this.waitingPool = 0L;
        return wait;
    }

    @Override
    public synchronized void start() {
        this.filler.start();
    }
}

