/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MultiMapLookup<V>
implements Map<String, V> {
    private final List<Map<String, V>> maps = new ArrayList<Map<String, V>>();

    public MultiMapLookup() {
    }

    public MultiMapLookup(Map<String, V> map1, Map<String, V> map2) {
        this.add(map1);
        this.add(map2);
    }

    public MultiMapLookup<V> add(Map<String, V> map) {
        this.maps.add(map);
        return this;
    }

    @Override
    public int size() {
        long count = this.maps.stream().map(Map::keySet).flatMap(Collection::stream).distinct().count();
        return (int)count;
    }

    @Override
    public boolean isEmpty() {
        return this.maps.stream().allMatch(Map::isEmpty);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.maps.stream().anyMatch(m -> m.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.maps.stream().anyMatch(m -> m.containsValue(value));
    }

    @Override
    public V get(Object key) {
        return this.maps.stream().filter(m -> m.containsKey(String.valueOf(key))).findFirst().map(m -> m.get(key)).orElse(null);
    }

    @Override
    public V put(String key, V value) {
        throw this.immutable();
    }

    @Override
    public V remove(Object key) {
        V result = this.get(key);
        this.maps.stream().forEach((? super T m) -> m.remove(String.valueOf(key)));
        return result;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        throw this.immutable();
    }

    @Override
    public void clear() {
        throw this.immutable();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.maps.stream().map(Map::keySet).flatMap(Collection::stream).forEach(keys::add);
        return keys;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashMap<String, V> compositeMap = new HashMap<String, V>();
        for (Map<String, V> map : this.maps) {
            for (Map.Entry<String, V> entry : map.entrySet()) {
                if (compositeMap.containsKey(entry.getKey())) continue;
                compositeMap.put(entry.getKey(), entry.getValue());
            }
        }
        return compositeMap.entrySet();
    }

    private RuntimeException immutable() {
        return new RuntimeException("This map is not meant to be mutable.");
    }

    public String toString() {
        return this.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(","));
    }
}

