/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig;

import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDocList;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsLoader;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDocList;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatementsLoader {
    public static String[] YAML_EXTENSIONS = new String[]{"yaml", "yml"};
    private static final Logger logger = LogManager.getLogger(StatementsLoader.class);

    public static StmtsDocList loadString(String yamlContent, Map<String, ?> params) {
        StrInterpolator transformer = new StrInterpolator(params);
        RawStmtsLoader loader = new RawStmtsLoader(transformer);
        RawStmtsDocList rawDocList = loader.loadString(logger, yamlContent);
        StmtsDocList layered = new StmtsDocList(rawDocList);
        transformer.checkpointAccesses().forEach((k, v) -> {
            layered.addTemplateVariable((String)k, (String)v);
            if (params.containsKey(k)) {
                params.remove(k);
            }
        });
        return layered;
    }

    public static StmtsDocList loadStmt(Logger logger, String statement, Map<String, ?> params) {
        StrInterpolator transformer = new StrInterpolator(params);
        statement = transformer.apply(statement);
        RawStmtsDocList rawStmtsDocList = RawStmtsDocList.forSingleStatement(statement);
        StmtsDocList layered = new StmtsDocList(rawStmtsDocList);
        transformer.checkpointAccesses().forEach((k, v) -> {
            layered.addTemplateVariable((String)k, (String)v);
            params.remove(k);
        });
        return layered;
    }

    public static StmtsDocList loadContent(Logger logger, Content<?> content, Map<String, String> params) {
        return StatementsLoader.loadString(content.get().toString(), params);
    }

    public static StmtsDocList loadPath(Logger logger, String path, Map<String, ?> params, String ... searchPaths) {
        Object list = null;
        Optional oyaml = NBIO.all().prefix(searchPaths).name(new String[]{path}).extension(YAML_EXTENSIONS).first();
        String content = oyaml.map(Content::asString).orElseThrow(() -> new BasicError("Unable to load " + path));
        return StatementsLoader.loadString(content, params);
    }

    public static StmtsDocList loadPath(Logger logger, String path, String ... searchPaths) {
        return StatementsLoader.loadPath(logger, path, Map.of(), searchPaths);
    }
}

