/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.nb.api.errors.OpConfigError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;

public class NbYamlVersionCheck {
    private final Properties versionProperties = new Properties();

    public NbYamlVersionCheck() {
        InputStream versionStream = this.getClass().getResourceAsStream("/version.properties");
        try {
            this.versionProperties.load(versionStream);
        }
        catch (IOException e) {
            throw new RuntimeException("unable to read version properties:" + e);
        }
    }

    public String getVersion() {
        return this.versionProperties.getProperty("version");
    }

    public String getArtifactId() {
        return this.versionProperties.getProperty("artifactId");
    }

    public String getGroupId() {
        return this.versionProperties.getProperty("groupId");
    }

    public String getArtifactCoordinates() {
        return "<dependency>\n <groupId>" + this.getGroupId() + "</groupId>\n <artifactId>" + this.getArtifactId() + "</artifactId>\n <version>" + this.getVersion() + "</version>\n</dependency>";
    }

    public void assertNewer(String min_version) {
        String[] min_components = min_version.split("\\.|-|_");
        String[] current_components = this.getVersion().split("\\.|-|_");
        for (int i = 0; i < min_components.length; ++i) {
            String minField = min_components[i];
            String currentField = current_components[i];
            if (minField.matches("\\d+")) {
                if (currentField.matches("\\d+")) {
                    if (Integer.parseInt(currentField) >= Integer.parseInt(minField)) continue;
                    throw new OpConfigError("This workload can only be loaded by a NoSQLBench runtime version " + min_version + " or higher. You are running version " + this.getVersion());
                }
                throw new OpConfigError("could not compare min_version '" + min_version + " to current version " + this.getVersion());
            }
            throw new OpConfigError("It is impossible to compare min_version " + min_version + " numerically with " + this.getVersion());
        }
    }

    public void assertVersionPattern(String versionRegex) {
        String version;
        Pattern versionpattern;
        if (versionRegex != null && !(versionpattern = Pattern.compile(versionRegex)).matcher(version = this.getVersion()).matches()) {
            throw new OpConfigError("Unable to load yaml with this version '" + version + " since the required version doesn't match version_regex '" + versionRegex + "' from yaml.");
        }
    }
}

