/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.nb.api.errors.BasicError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RawScenarios {
    public static String STEPNAME = "%03d";
    private final Map<String, Map<String, String>> scenarios = new LinkedHashMap<String, Map<String, String>>();

    public List<String> getScenarioNames() {
        return new ArrayList<String>(this.scenarios.keySet());
    }

    public void setPropertiesByReflection(Object scenariosObject) {
        this.scenarios.clear();
        Objects.requireNonNull(scenariosObject);
        if (scenariosObject instanceof Map) {
            Map rawNamedScenarios = (Map)scenariosObject;
            for (Map.Entry namedEntry : rawNamedScenarios.entrySet()) {
                String scenarioName = (String)namedEntry.getKey();
                Object scenarioObj = namedEntry.getValue();
                if (scenarioObj == null) {
                    throw new BasicError("Unable to use a null value for scenario named " + scenarioName + " in yaml.");
                }
                if (scenarioObj instanceof CharSequence) {
                    this.scenarios.put(scenarioName, Map.of(String.format(STEPNAME, 1), scenarioObj.toString()));
                    continue;
                }
                if (scenarioObj instanceof List) {
                    List list = (List)scenarioObj;
                    LinkedHashMap<String, String> scenarioMap = new LinkedHashMap<String, String>();
                    for (int i = 0; i < list.size(); ++i) {
                        scenarioMap.put(String.format(STEPNAME, i), (String)list.get(i));
                    }
                    this.scenarios.put(scenarioName, scenarioMap);
                    continue;
                }
                if (!(scenarioObj instanceof Map)) continue;
                this.scenarios.put(scenarioName, (Map)scenarioObj);
            }
        } else {
            throw new RuntimeException("Named scenarios must be a map at the top level, instead found '" + scenariosObject.getClass().getCanonicalName() + "'");
        }
    }

    public Map<String, String> getNamedScenario(String scenarioName) {
        return this.scenarios.get(scenarioName);
    }
}

