/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtFields;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RawStmtDef
extends RawStmtFields {
    private Object op;
    private static final List<String> opNames = List.of("stmt", "statement", "op", "operation");

    public RawStmtDef() {
    }

    public RawStmtDef(String name, String op) {
        this.setName(name);
        this.op = op;
    }

    public RawStmtDef(String defaultName, Map<String, Object> map) {
        HashSet<String> found = new HashSet<String>();
        for (String opName : opNames) {
            if (!map.containsKey(opName)) continue;
            found.add(opName);
        }
        if (found.size() > 1) {
            throw new BasicError("You used " + found + " as an op name, but only one of these is allowed.");
        }
        if (found.size() == 1) {
            Object op = map.remove(found.iterator().next());
            this.setOp(op);
        }
        Optional.ofNullable((String)map.remove("name")).ifPresent(this::setName);
        Optional.ofNullable((String)map.remove("desc")).ifPresent(this::setDesc);
        Optional.ofNullable((String)map.remove("description")).ifPresent(this::setDesc);
        Optional.ofNullable((Map)map.remove("tags")).ifPresent(this::setTags);
        Optional.ofNullable((Map)map.remove("bindings")).ifPresent(this::setBindings);
        Optional.ofNullable((Map)map.remove("params")).ifPresent(this::setParams);
        if (this.op == null) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            if (!iterator.hasNext()) {
                throw new RuntimeException("undefined-name-statement-tuple: The statement is not set, and no statements remain to pull 'name: statement' values from. For more details on this error see the troubleshooting section of the YAML format docs for undefined-name-statement-tuple");
            }
            Map.Entry<String, Object> firstEntry = iterator.next();
            if (firstEntry.getValue() instanceof Map && map.size() == 1) {
                Map values = (Map)firstEntry.getValue();
                this.setFieldsByReflection(values);
                map = values;
            } else if (firstEntry.getValue() instanceof CharSequence) {
                this.setStmt(((CharSequence)firstEntry.getValue()).toString());
            }
            if (this.getName().isEmpty()) {
                map.remove(firstEntry.getKey());
                this.setName(firstEntry.getKey());
            }
        }
        if (this.getName().isEmpty()) {
            this.setName(defaultName);
        }
        map.forEach((key, value) -> this.getParams().put((String)key, value));
    }

    private void setOp(Object op) {
        this.op = op;
    }

    public String getStmt() {
        if (this.op instanceof CharSequence) {
            return this.op.toString();
        }
        throw new BasicError("tried to access a non-char statement definition with #getStmt()");
    }

    public Object getOp() {
        return this.op;
    }

    private void setStmt(String statement) {
        this.op = statement;
    }

    @Override
    public String getName() {
        Object name = this.getParams().get("name");
        if (name != null) {
            return name.toString();
        }
        return super.getName();
    }
}

