/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.engine.api.activityconfig.rawyaml.Tags;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RawStmtFields
extends Tags {
    private static final Logger logger = LogManager.getLogger(RawStmtFields.class);
    private String name = "";
    private String desc = "";
    private final Map<String, String> bindings = new LinkedHashMap<String, String>();
    private final Map<String, Object> params = new LinkedHashMap<String, Object>();

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getBindings() {
        return Collections.unmodifiableMap(this.bindings);
    }

    public void setBindings(Map<String, String> bindings) {
        this.bindings.clear();
        this.bindings.putAll(bindings);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> config) {
        this.params.clear();
        this.params.putAll(config);
    }

    public void applyBlockParams(RawStmtFields other) {
        this.setName(other.getName());
        this.setBindings(other.getBindings());
        this.setTags(other.getTags());
        this.setParams(other.getParams());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setFieldsByReflection(Map<String, Object> propsmap) {
        Object paramsObject;
        Object bindingsObject;
        Object nameObj;
        Object descriptionObj = propsmap.remove("description");
        if (descriptionObj == null) {
            descriptionObj = propsmap.remove("desc");
        }
        if (descriptionObj != null) {
            this.setDescription(descriptionObj.toString());
        }
        if ((nameObj = propsmap.remove("name")) != null) {
            this.setName(nameObj.toString());
        }
        if ((bindingsObject = propsmap.remove("bindings")) != null) {
            if (!(bindingsObject instanceof Map)) throw new RuntimeException("Invalid type for bindings object: " + bindingsObject.getClass().getCanonicalName());
            Map bindingsMap = (Map)bindingsObject;
            if (bindingsMap == null) throw new BasicError("Empty bindings map");
            for (Object bkey : bindingsMap.keySet()) {
                Object bval = bindingsMap.get(bkey);
                if (bval != null) {
                    this.bindings.put(bkey.toString(), bval.toString());
                    continue;
                }
                logger.warn("empty bindings entry for " + bkey);
            }
        }
        if ((paramsObject = propsmap.remove("params")) != null) {
            if (!(paramsObject instanceof Map)) throw new RuntimeException("Invalid type for params object:" + paramsObject.getClass().getCanonicalName());
            Map paramsMap = (Map)paramsObject;
            paramsMap.forEach((ko, vo) -> {
                String paramkey = ko.toString();
                Object paramVal = vo;
                this.params.put(paramkey, paramVal);
            });
        }
        super.setFieldsByReflection(propsmap);
    }
}

