/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.engine.api.activityconfig.rawyaml.NbYamlVersionCheck;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawScenarios;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsBlock;
import io.nosqlbench.engine.api.activityconfig.rawyaml.StatementsOwner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RawStmtsDoc
extends StatementsOwner {
    private RawScenarios scenarios = new RawScenarios();
    private final List<RawStmtsBlock> blocks = new ArrayList<RawStmtsBlock>();

    public static RawStmtsDoc forSingleStatement(String statement) {
        RawStmtsDoc rawStmtsDoc = new RawStmtsDoc();
        rawStmtsDoc.setStatementsFieldByType(statement);
        return rawStmtsDoc;
    }

    @Override
    public void setFieldsByReflection(Map<String, Object> properties) {
        Object scenariosData;
        Object blocksObjects;
        if (properties.containsKey("version_regex")) {
            String versionRegex = properties.remove("version_regex").toString();
            new NbYamlVersionCheck().assertVersionPattern(versionRegex);
        }
        if (properties.containsKey("min_version")) {
            String min_version = properties.remove("min_version").toString();
            new NbYamlVersionCheck().assertNewer(min_version);
        }
        if ((blocksObjects = properties.remove("blocks")) instanceof List) {
            List blockList = (List)blocksObjects;
            for (Object blockData : blockList) {
                if (blockData instanceof Map) {
                    Map blockDataMap = (Map)blockData;
                    RawStmtsBlock rawStmtsBlock = new RawStmtsBlock();
                    rawStmtsBlock.setFieldsByReflection(blockDataMap);
                    this.blocks.add(rawStmtsBlock);
                    continue;
                }
                throw new RuntimeException("Invalid object type for block data: " + blockData.getClass().getCanonicalName());
            }
        } else if (blocksObjects instanceof Map) {
            Map blockDataAsMap = (Map)blocksObjects;
            for (Map.Entry entry : blockDataAsMap.entrySet()) {
                String blockName = (String)entry.getKey();
                Object blockData = entry.getValue();
                if (blockData instanceof Map) {
                    Map blockDataMap = (Map)blockData;
                    RawStmtsBlock rawStmtsBlock = new RawStmtsBlock();
                    rawStmtsBlock.setName(blockName);
                    rawStmtsBlock.setFieldsByReflection(blockDataMap);
                    this.blocks.add(rawStmtsBlock);
                    continue;
                }
                throw new RuntimeException("Invalid object type for block data: " + blockData.getClass().getCanonicalName());
            }
        } else if (blocksObjects != null) {
            throw new RuntimeException("Type of blocks interior data type not recognized:" + blocksObjects.getClass().getCanonicalName());
        }
        if ((scenariosData = properties.remove("scenarios")) != null) {
            this.scenarios.setPropertiesByReflection(scenariosData);
        }
        super.setFieldsByReflection(properties);
    }

    public List<RawStmtsBlock> getBlocks() {
        ArrayList<RawStmtsBlock> stmtBlocks = new ArrayList<RawStmtsBlock>();
        if (!this.getRawStmtDefs().isEmpty()) {
            RawStmtsBlock rawStmtsBlock = new RawStmtsBlock();
            rawStmtsBlock.setName("block0");
            rawStmtsBlock.setRawStmtDefs(this.getRawStmtDefs());
            stmtBlocks.add(rawStmtsBlock);
        }
        stmtBlocks.addAll(this.blocks);
        return stmtBlocks;
    }

    public void setBlocks(List<RawStmtsBlock> blocks) {
        this.blocks.clear();
        this.blocks.addAll(blocks);
    }

    public RawScenarios getRawScenarios() {
        return this.scenarios;
    }

    public void setScenarios(RawScenarios scenarios) {
        this.scenarios = scenarios;
    }
}

