/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.rawyaml;

import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.ActivityInitializationError;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class RawYamlLoader {
    public static String[] YAML_EXTENSIONS = new String[]{"yaml", "yml"};
    List<Function<String, String>> stringTransformers = new ArrayList<Function<String, String>>();
    private final ArrayList<Function<String, String>> transformers = new ArrayList();

    private void addTransformer(Function<String, String> newTransformer) {
        Collections.addAll(this.transformers, newTransformer);
    }

    public RawYamlLoader() {
        this.addTransformer(new StrInterpolator(new ActivityDef[0]));
    }

    public List<Map<String, Object>> loadString(Logger logger, String data) {
        try {
            if (logger != null) {
                logger.trace("Applying string transformer to yaml data:" + data);
            }
            for (Function<String, String> transformer : this.transformers) {
                data = transformer.apply(data);
            }
        }
        catch (Exception e) {
            ActivityInitializationError t = new ActivityInitializationError("Error applying string transforms to input", e);
            throw t;
        }
        return this.parseYaml(logger, data);
    }

    public List<Map<String, Object>> loadPath(Logger logger, String path, String ... searchPaths) {
        String data = null;
        try {
            Optional oyaml = NBIO.all().prefix(searchPaths).name(new String[]{path}).extension(YAML_EXTENSIONS).first();
            data = oyaml.map(Content::asString).orElseThrow(() -> new BasicError("Unable to load " + path));
            return this.loadString(logger, data);
        }
        catch (Exception e) {
            throw new RuntimeException("error while reading file " + path, e);
        }
    }

    private List<Map<String, Object>> parseYaml(Logger logger, String data) {
        Yaml yaml = new Yaml();
        Iterable objects = yaml.loadAll(data);
        ArrayList newDocList = new ArrayList();
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        for (Object object : objects) {
            if (object instanceof Map) {
                maps.add(new LinkedHashMap((Map)object));
                continue;
            }
            throw new RuntimeException("Unable to coerce a non-map type to a statements yaml doc: " + object.getClass().getCanonicalName());
        }
        return maps;
    }

    protected String applyTransforms(Logger logger, String data) {
        for (Function<String, String> xform : this.stringTransformers) {
            try {
                if (logger != null) {
                    logger.trace("Applying string transformer to yaml data:" + xform);
                }
                data = xform.apply(data);
            }
            catch (Exception e) {
                ActivityInitializationError t = new ActivityInitializationError("Error applying string transforms to input", e);
                throw t;
            }
        }
        return data;
    }
}

