/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import io.nosqlbench.engine.api.activityconfig.MultiMapLookup;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtDef;
import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsBlock;
import io.nosqlbench.nb.api.errors.BasicError;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpDef
extends OpTemplate {
    private static final Logger logger = LogManager.getLogger(OpDef.class);
    private final RawStmtDef rawStmtDef;
    private final StmtsBlock block;
    private final LinkedHashMap<String, Object> params;
    private final LinkedHashMap<String, String> bindings;
    private final LinkedHashMap<String, String> tags;

    public OpDef(StmtsBlock block, RawStmtDef rawStmtDef) {
        this.block = block;
        this.rawStmtDef = rawStmtDef;
        this.params = this.composeParams();
        this.bindings = this.composeBindings();
        this.tags = this.composeTags();
    }

    public String getName() {
        return this.block.getName() + "--" + this.rawStmtDef.getName();
    }

    public Optional<Map<String, Object>> getOp() {
        Object op = this.rawStmtDef.getOp();
        if (op == null) {
            return null;
        }
        LinkedHashMap<String, String> newmap = new LinkedHashMap<String, String>();
        if (op instanceof Map) {
            ((Map)op).forEach((k, v) -> newmap.put(k.toString(), (String)v));
        } else if (op instanceof CharSequence) {
            newmap.put("stmt", op.toString());
        } else {
            throw new BasicError("Unable to coerce a '" + op.getClass().getCanonicalName() + "' into an op template");
        }
        return Optional.of(newmap);
    }

    public LinkedHashMap<String, String> getBindings() {
        return this.bindings;
    }

    private LinkedHashMap<String, String> composeBindings() {
        MultiMapLookup<String> lookup = new MultiMapLookup<String>(this.rawStmtDef.getBindings(), this.block.getBindings());
        return new LinkedHashMap<String, String>(lookup);
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    private LinkedHashMap<String, Object> composeParams() {
        MultiMapLookup<Object> lookup = new MultiMapLookup<Object>(this.rawStmtDef.getParams(), this.block.getParams());
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(lookup);
        return params;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    private LinkedHashMap<String, String> composeTags() {
        LinkedHashMap<String, String> tagsWithName = new LinkedHashMap<String, String>(new MultiMapLookup<String>(this.rawStmtDef.getTags(), this.block.getTags()));
        tagsWithName.put("name", this.getName());
        tagsWithName.put("block", this.block.getName());
        return tagsWithName;
    }

    public String toString() {
        return "stmt(name:" + this.getName() + ", stmt:" + this.getOp() + ", tags:(" + this.getTags() + "), params:(" + this.getParams() + "), bindings:(" + (LinkedHashMap)this.getBindings() + "))";
    }

    public String getDesc() {
        return this.rawStmtDef.getDesc();
    }
}

