/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import io.nosqlbench.engine.api.activityconfig.MultiMapLookup;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtDef;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsBlock;
import io.nosqlbench.engine.api.activityconfig.yaml.OpDef;
import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDoc;
import io.nosqlbench.engine.api.util.Tagged;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class StmtsBlock
implements Tagged,
Iterable<OpTemplate> {
    private final RawStmtsBlock rawStmtsBlock;
    private final StmtsDoc rawStmtsDoc;
    private final int blockIdx;

    public StmtsBlock(RawStmtsBlock rawStmtsBlock, StmtsDoc rawStmtsDoc, int blockIdx) {
        this.rawStmtsBlock = rawStmtsBlock;
        this.rawStmtsDoc = rawStmtsDoc;
        this.blockIdx = blockIdx;
    }

    public List<OpTemplate> getOps() {
        ArrayList<OpTemplate> rawOpTemplates = new ArrayList<OpTemplate>();
        List<RawStmtDef> statements = this.rawStmtsBlock.getRawStmtDefs();
        for (int i = 0; i < statements.size(); ++i) {
            rawOpTemplates.add(new OpDef(this, statements.get(i)));
        }
        return rawOpTemplates;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (!this.rawStmtsDoc.getName().isEmpty()) {
            sb.append(this.rawStmtsDoc.getName()).append("--");
        }
        if (!this.rawStmtsBlock.getName().isEmpty()) {
            sb.append(this.rawStmtsBlock.getName());
        } else {
            sb.append("block").append(this.blockIdx);
        }
        return sb.toString();
    }

    public Map<String, String> getTags() {
        return new MultiMapLookup<String>(this.rawStmtsBlock.getTags(), this.rawStmtsDoc.getTags());
    }

    public Map<String, Object> getParams() {
        return new MultiMapLookup<Object>(this.rawStmtsBlock.getParams(), this.rawStmtsDoc.getParams());
    }

    public Map<String, String> getParamsAsText() {
        MultiMapLookup<Object> lookup = new MultiMapLookup<Object>(this.rawStmtsBlock.getParams(), this.rawStmtsDoc.getParams());
        LinkedHashMap<String, String> stringmap = new LinkedHashMap<String, String>();
        lookup.forEach((? super K k, ? super V v) -> stringmap.put((String)k, v.toString()));
        return stringmap;
    }

    public <V> V getParamOrDefault(String name, V defaultValue) {
        Objects.requireNonNull(defaultValue);
        MultiMapLookup<Object> lookup = new MultiMapLookup<Object>(this.rawStmtsBlock.getParams(), this.rawStmtsDoc.getParams());
        if (!lookup.containsKey(name)) {
            return defaultValue;
        }
        Object value = lookup.get(name);
        return (V)defaultValue.getClass().cast(value);
    }

    public <V> V getParam(String name, Class<? extends V> type) {
        MultiMapLookup<Object> lookup = new MultiMapLookup<Object>(this.rawStmtsBlock.getParams(), this.rawStmtsDoc.getParams());
        Object object = lookup.get(name);
        V value = type.cast(object);
        return value;
    }

    public Map<String, String> getBindings() {
        return new MultiMapLookup<String>(this.rawStmtsBlock.getBindings(), this.rawStmtsDoc.getBindings());
    }

    @Override
    @NotNull
    public Iterator<OpTemplate> iterator() {
        return this.getOps().iterator();
    }
}

