/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsBlock;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDoc;
import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.engine.api.activityconfig.yaml.Scenarios;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsBlock;
import io.nosqlbench.engine.api.util.Tagged;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StmtsDoc
implements Tagged,
Iterable<StmtsBlock> {
    private final RawStmtsDoc rawStmtsDoc;

    public StmtsDoc(RawStmtsDoc rawStmtsDoc) {
        this.rawStmtsDoc = rawStmtsDoc;
    }

    public List<StmtsBlock> getBlocks() {
        ArrayList<StmtsBlock> blocks = new ArrayList<StmtsBlock>();
        int blockIdx = 0;
        for (RawStmtsBlock rawStmtsBlock : this.rawStmtsDoc.getBlocks()) {
            String compositeName = this.rawStmtsDoc.getName() + (String)(rawStmtsBlock.getName().isEmpty() ? "" : "-" + rawStmtsBlock.getName());
            StmtsBlock compositeBlock = new StmtsBlock(rawStmtsBlock, this, ++blockIdx);
            blocks.add(compositeBlock);
        }
        return blocks;
    }

    public Map<String, String> getTags() {
        return this.rawStmtsDoc.getTags();
    }

    public Map<String, Object> getParams() {
        return this.rawStmtsDoc.getParams();
    }

    public Map<String, String> getBindings() {
        return this.rawStmtsDoc.getBindings();
    }

    public String getName() {
        return this.rawStmtsDoc.getName();
    }

    public List<OpTemplate> getStmts() {
        return this.getBlocks().stream().flatMap(b -> b.getOps().stream()).collect(Collectors.toList());
    }

    @Override
    public Iterator<StmtsBlock> iterator() {
        return this.getBlocks().iterator();
    }

    public Scenarios getScenarios() {
        return new Scenarios(this.rawStmtsDoc.getRawScenarios());
    }

    public String getDescription() {
        return this.rawStmtsDoc.getDesc();
    }
}

