/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsDocList;
import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.engine.api.activityconfig.yaml.Scenarios;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDoc;
import io.nosqlbench.engine.api.util.TagFilter;
import io.nosqlbench.nb.api.config.standard.ConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfigModel;
import io.nosqlbench.nb.api.config.standard.Param;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StmtsDocList
implements Iterable<StmtsDoc> {
    private final RawStmtsDocList rawStmtsDocList;
    private final Map<String, String> templateVariables = new LinkedHashMap<String, String>();

    public StmtsDocList(RawStmtsDocList rawStmtsDocList) {
        this.rawStmtsDocList = rawStmtsDocList;
    }

    public List<StmtsDoc> getStmtDocs(String tagFilter) {
        TagFilter tf = new TagFilter(tagFilter);
        return this.getStmtDocs().stream().filter(tf::matchesTagged).collect(Collectors.toList());
    }

    public List<StmtsDoc> getStmtDocs() {
        return this.rawStmtsDocList.getStmtsDocs().stream().map(StmtsDoc::new).collect(Collectors.toList());
    }

    public List<OpTemplate> getStmts() {
        return this.getStmts("");
    }

    public List<OpTemplate> getStmts(String tagFilterSpec) {
        TagFilter ts = new TagFilter(tagFilterSpec);
        ArrayList<OpTemplate> opTemplates = new ArrayList<OpTemplate>();
        this.getStmtDocs().stream().flatMap(d -> d.getStmts().stream()).filter(ts::matchesTagged).forEach(opTemplates::add);
        return opTemplates;
    }

    @Override
    public Iterator<StmtsDoc> iterator() {
        return this.getStmtDocs().iterator();
    }

    public Map<String, String> getDocBindings() {
        LinkedHashMap<String, String> docBindings = new LinkedHashMap<String, String>();
        this.getStmtDocs().stream().map(StmtsDoc::getBindings).forEach(docBindings::putAll);
        return docBindings;
    }

    public Scenarios getDocScenarios() {
        if (this.getStmtDocs().size() == 0) {
            throw new RuntimeException("No statement docs were found, so source file is empty.");
        }
        return this.getStmtDocs().get(0).getScenarios();
    }

    public String getDescription() {
        return this.getStmtDocs().get(0).getDescription();
    }

    public Map<String, String> getTemplateVariables() {
        return this.templateVariables;
    }

    public void addTemplateVariable(String key, String defaultValue) {
        this.templateVariables.put(key, defaultValue);
    }

    public NBConfigModel getConfigModel() {
        ConfigModel cfgmodel = ConfigModel.of(StmtsDocList.class);
        this.getTemplateVariables().forEach((? super K k, ? super V v) -> cfgmodel.add(Param.defaultTo((String)k, (Object)v, (String)"template parameter found in the yaml workload")));
        return cfgmodel.asReadOnly();
    }
}

