/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl;

import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.activityapi.core.ActionDispenser;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.core.ActivityController;
import io.nosqlbench.engine.api.activityapi.core.ActivityInstrumentation;
import io.nosqlbench.engine.api.activityapi.core.CoreActivityInstrumentation;
import io.nosqlbench.engine.api.activityapi.core.MotorDispenser;
import io.nosqlbench.engine.api.activityapi.core.ProgressMeter;
import io.nosqlbench.engine.api.activityapi.core.RunState;
import io.nosqlbench.engine.api.activityapi.cyclelog.filters.IntPredicateDispenser;
import io.nosqlbench.engine.api.activityapi.errorhandling.ErrorMetrics;
import io.nosqlbench.engine.api.activityapi.errorhandling.modular.NBErrorHandler;
import io.nosqlbench.engine.api.activityapi.input.Input;
import io.nosqlbench.engine.api.activityapi.input.InputDispenser;
import io.nosqlbench.engine.api.activityapi.output.OutputDispenser;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.SequencePlanner;
import io.nosqlbench.engine.api.activityapi.planning.SequencerType;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiter;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateLimiters;
import io.nosqlbench.engine.api.activityapi.ratelimits.RateSpec;
import io.nosqlbench.engine.api.activityconfig.StatementsLoader;
import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDocList;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.OpDispenser;
import io.nosqlbench.engine.api.activityimpl.ProgressAndStateMeter;
import io.nosqlbench.engine.api.activityimpl.input.ProgressCapable;
import io.nosqlbench.engine.api.activityimpl.uniform.flowtypes.Op;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import io.nosqlbench.engine.api.templating.CommandTemplate;
import io.nosqlbench.engine.api.templating.ParsedOp;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.nb.api.errors.OpConfigError;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleActivity
implements Activity,
ProgressCapable {
    private static final Logger logger = LogManager.getLogger((String)"ACTIVITY");
    protected ActivityDef activityDef;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private MotorDispenser motorDispenser;
    private InputDispenser inputDispenser;
    private ActionDispenser actionDispenser;
    private OutputDispenser markerDispenser;
    private IntPredicateDispenser resultFilterDispenser;
    private RunState runState = RunState.Uninitialized;
    private RateLimiter strideLimiter;
    private RateLimiter cycleLimiter;
    private RateLimiter phaseLimiter;
    private ActivityController activityController;
    private ActivityInstrumentation activityInstrumentation;
    private PrintWriter console;
    private long startedAtMillis;
    private int nameEnumerator = 0;
    private ErrorMetrics errorMetrics;
    private NBErrorHandler errorHandler;

    public SimpleActivity(ActivityDef activityDef) {
        this.activityDef = activityDef;
        if (activityDef.getAlias().equals("UNNAMEDACTIVITY")) {
            Optional workloadOpt = activityDef.getParams().getOptionalString(new String[]{"workload", "yaml"});
            if (workloadOpt.isPresent()) {
                activityDef.getParams().set("alias", workloadOpt.get());
            } else {
                activityDef.getParams().set("alias", (Object)(activityDef.getActivityType().toUpperCase(Locale.ROOT) + String.valueOf(this.nameEnumerator++)));
            }
        }
    }

    public SimpleActivity(String activityDefString) {
        this(ActivityDef.parseActivityDef((String)activityDefString));
    }

    @Override
    public void initActivity() {
        this.onActivityDefUpdate(this.activityDef);
    }

    public synchronized NBErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new NBErrorHandler(() -> this.activityDef.getParams().getOptionalString(new String[]{"errors"}).orElse("stop"), () -> this.getExceptionMetrics(), this.getErrorNameMapper());
        }
        return this.errorHandler;
    }

    @Override
    public synchronized RunState getRunState() {
        return this.runState;
    }

    @Override
    public synchronized void setRunState(RunState runState) {
        this.runState = runState;
        if (runState == RunState.Running) {
            this.startedAtMillis = System.currentTimeMillis();
        }
    }

    @Override
    public long getStartedAtMillis() {
        return this.startedAtMillis;
    }

    @Override
    public final MotorDispenser getMotorDispenserDelegate() {
        return this.motorDispenser;
    }

    @Override
    public final void setMotorDispenserDelegate(MotorDispenser motorDispenser) {
        this.motorDispenser = motorDispenser;
    }

    @Override
    public final InputDispenser getInputDispenserDelegate() {
        return this.inputDispenser;
    }

    @Override
    public final void setInputDispenserDelegate(InputDispenser inputDispenser) {
        this.inputDispenser = inputDispenser;
    }

    @Override
    public final ActionDispenser getActionDispenserDelegate() {
        return this.actionDispenser;
    }

    @Override
    public final void setActionDispenserDelegate(ActionDispenser actionDispenser) {
        this.actionDispenser = actionDispenser;
    }

    @Override
    public IntPredicateDispenser getResultFilterDispenserDelegate() {
        return this.resultFilterDispenser;
    }

    @Override
    public void setResultFilterDispenserDelegate(IntPredicateDispenser resultFilterDispenser) {
        this.resultFilterDispenser = resultFilterDispenser;
    }

    @Override
    public OutputDispenser getMarkerDispenserDelegate() {
        return this.markerDispenser;
    }

    @Override
    public void setOutputDispenserDelegate(OutputDispenser outputDispenser) {
        this.markerDispenser = outputDispenser;
    }

    @Override
    public ActivityDef getActivityDef() {
        return this.activityDef;
    }

    public String toString() {
        return this.getAlias();
    }

    @Override
    public int compareTo(Activity o) {
        return this.getAlias().compareTo(o.getAlias());
    }

    @Override
    public ActivityController getActivityController() {
        return this.activityController;
    }

    @Override
    public void setActivityController(ActivityController activityController) {
        this.activityController = activityController;
    }

    @Override
    public void registerAutoCloseable(AutoCloseable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void closeAutoCloseables() {
        for (AutoCloseable closeable : this.closeables) {
            logger.debug("CLOSING " + closeable.getClass().getCanonicalName() + ": " + closeable.toString());
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing " + closeable);
            }
        }
        this.closeables.clear();
    }

    @Override
    public RateLimiter getCycleLimiter() {
        return this.cycleLimiter;
    }

    @Override
    public synchronized void setCycleLimiter(RateLimiter rateLimiter) {
        this.cycleLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getCycleRateLimiter(Supplier<? extends RateLimiter> s) {
        if (this.cycleLimiter == null) {
            this.cycleLimiter = s.get();
        }
        return this.cycleLimiter;
    }

    @Override
    public synchronized RateLimiter getStrideLimiter() {
        return this.strideLimiter;
    }

    @Override
    public synchronized void setStrideLimiter(RateLimiter rateLimiter) {
        this.strideLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getStrideRateLimiter(Supplier<? extends RateLimiter> s) {
        if (this.strideLimiter == null) {
            this.strideLimiter = s.get();
        }
        return this.strideLimiter;
    }

    @Override
    public RateLimiter getPhaseLimiter() {
        return this.phaseLimiter;
    }

    @Override
    public Timer getResultTimer() {
        return ActivityMetrics.timer((ActivityDef)this.getActivityDef(), (String)"result");
    }

    @Override
    public void setPhaseLimiter(RateLimiter rateLimiter) {
        this.phaseLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getPhaseRateLimiter(Supplier<? extends RateLimiter> supplier) {
        if (this.phaseLimiter == null) {
            this.phaseLimiter = supplier.get();
        }
        return this.phaseLimiter;
    }

    @Override
    public synchronized ActivityInstrumentation getInstrumentation() {
        if (this.activityInstrumentation == null) {
            this.activityInstrumentation = new CoreActivityInstrumentation(this);
        }
        return this.activityInstrumentation;
    }

    @Override
    public synchronized PrintWriter getConsoleOut() {
        if (this.console == null) {
            this.console = new PrintWriter(System.out);
        }
        return this.console;
    }

    @Override
    public synchronized InputStream getConsoleIn() {
        return System.in;
    }

    @Override
    public void setConsoleOut(PrintWriter writer) {
        this.console = writer;
    }

    @Override
    public synchronized ErrorMetrics getExceptionMetrics() {
        if (this.errorMetrics == null) {
            this.errorMetrics = new ErrorMetrics(this.getActivityDef());
        }
        return this.errorMetrics;
    }

    @Override
    public synchronized void onActivityDefUpdate(ActivityDef activityDef) {
        activityDef.getParams().getOptionalNamedParameter(new String[]{"striderate"}).map(RateSpec::new).ifPresent(spec -> {
            this.strideLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "strides", this.strideLimiter, spec);
        });
        activityDef.getParams().getOptionalNamedParameter(new String[]{"cyclerate", "targetrate", "rate"}).map(RateSpec::new).ifPresent(spec -> {
            this.cycleLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "cycles", this.cycleLimiter, spec);
        });
        activityDef.getParams().getOptionalNamedParameter(new String[]{"phaserate"}).map(RateSpec::new).ifPresent(spec -> {
            this.phaseLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "phases", this.phaseLimiter, spec);
        });
    }

    public void setDefaultsFromOpSequence(OpSequence<?> seq) {
        Optional threadSpec;
        Optional cyclesOpt;
        Optional strideOpt = this.getParams().getOptionalString(new String[]{"stride"});
        if (strideOpt.isEmpty()) {
            String stride = String.valueOf(seq.getSequence().length);
            logger.info("defaulting stride to " + stride + " (the sequence length)");
            this.getParams().set("stride", (Object)stride);
        }
        if ((cyclesOpt = this.getParams().getOptionalString(new String[]{"cycles"})).isEmpty()) {
            String cycles = (String)this.getParams().getOptionalString(new String[]{"stride"}).orElseThrow();
            logger.info("defaulting cycles to " + cycles + " (the stride length)");
            this.getParams().set("cycles", this.getParams().getOptionalString(new String[]{"stride"}).orElseThrow());
        } else {
            if (this.getActivityDef().getCycleCount() == 0L) {
                throw new RuntimeException("You specified cycles, but the range specified means zero cycles: " + this.getParams().get((Object)"cycles"));
            }
            long stride = (Long)this.getParams().getOptionalLong("stride").orElseThrow();
            long cycles = this.getActivityDef().getCycleCount();
            if (cycles < stride) {
                throw new RuntimeException("The specified cycles (" + cycles + ") are less than the stride (" + stride + "). This means there aren't enough cycles to cause a stride to be executed. If this was intended, then set stride low enough to allow it.");
            }
        }
        long cycleCount = this.getActivityDef().getCycleCount();
        long stride = (Long)this.getActivityDef().getParams().getOptionalLong("stride").orElseThrow();
        if (stride > 0L && cycleCount % stride != 0L) {
            logger.warn("The stride does not evenly divide cycles. Only full strides will be executed,leaving some cycles unused. (stride=" + stride + ", cycles=" + cycleCount + ")");
        }
        if ((threadSpec = this.activityDef.getParams().getOptionalString(new String[]{"threads"})).isPresent()) {
            String spec = (String)threadSpec.get();
            int processors = Runtime.getRuntime().availableProcessors();
            if (spec.toLowerCase().equals("auto")) {
                int threads = processors * 10;
                if ((long)threads > this.activityDef.getCycleCount()) {
                    threads = (int)this.activityDef.getCycleCount();
                    logger.info("setting threads to " + threads + " (auto) [10xCORES, cycle count limited]");
                } else {
                    logger.info("setting threads to " + threads + " (auto) [10xCORES]");
                }
                this.activityDef.setThreads(threads);
            } else if (spec.toLowerCase().matches("\\d+x")) {
                String multiplier = spec.substring(0, spec.length() - 1);
                int threads = processors * Integer.parseInt(multiplier);
                logger.info("setting threads to " + threads + " (" + multiplier + "x)");
                this.activityDef.setThreads(threads);
            } else if (spec.toLowerCase().matches("\\d+")) {
                logger.info("setting threads to " + spec + " (direct)");
                this.activityDef.setThreads(Integer.parseInt(spec));
            }
            if ((long)this.activityDef.getThreads() > this.activityDef.getCycleCount()) {
                logger.warn("threads=" + this.activityDef.getThreads() + " and cycles=" + this.activityDef.getCycleSummary() + ", you should have more cycles than threads.");
            }
        } else if (cycleCount > 1000L) {
            logger.warn("For testing at scale, it is highly recommended that you set threads to a value higher than the default of 1. hint: you can use threads=auto for reasonable default, or consult the topic on threads with `help threads` for more information.");
        }
        if (this.activityDef.getCycleCount() > 0L && seq.getOps().size() == 0) {
            throw new BasicError("You have configured a zero-length sequence and non-zero cycles. Tt is not possible to continue with this activity.");
        }
    }

    protected <O extends Op> OpSequence<OpDispenser<O>> createOpSequenceFromCommands(Function<CommandTemplate, OpDispenser<O>> opinit) {
        Function<OpTemplate, CommandTemplate> f = CommandTemplate::new;
        Function<OpTemplate, OpDispenser<O>> opTemplateOFunction = f.andThen(opinit);
        return this.createOpSequence(opTemplateOFunction);
    }

    protected <O extends Op> OpSequence<OpDispenser<O>> createOpSourceFromCommands(Function<ParsedOp, OpDispenser<O>> opinit, NBConfiguration cfg, List<Function<Map<String, Object>, Map<String, Object>>> parsers) {
        Function<OpTemplate, ParsedOp> f = t -> new ParsedOp(t, cfg, parsers);
        Function<OpTemplate, OpDispenser<O>> opTemplateOFunction = f.andThen(opinit);
        return this.createOpSequence(opTemplateOFunction);
    }

    @Deprecated(forRemoval=true)
    protected <O> OpSequence<OpDispenser<O>> createOpSequence(Function<OpTemplate, OpDispenser<O>> opinit) {
        int i;
        String tagfilter = this.activityDef.getParams().getOptionalString(new String[]{"tags"}).orElse("");
        StrInterpolator interp = new StrInterpolator(this.activityDef);
        SequencerType sequencerType = this.getParams().getOptionalString(new String[]{"seq"}).map(SequencerType::valueOf).orElse(SequencerType.bucket);
        SequencePlanner<OpDispenser<O>> planner = new SequencePlanner<OpDispenser<O>>(sequencerType);
        StmtsDocList stmtsDocList = null;
        Object workloadSource = "unspecified";
        Optional stmt = this.activityDef.getParams().getOptionalString(new String[]{"op", "stmt", "statement"});
        Optional op_yaml_loc = this.activityDef.getParams().getOptionalString(new String[]{"yaml", "workload"});
        if (stmt.isPresent()) {
            stmtsDocList = StatementsLoader.loadStmt(logger, (String)stmt.get(), this.activityDef.getParams());
            workloadSource = "commandline:" + (String)stmt.get();
        } else if (op_yaml_loc.isPresent()) {
            stmtsDocList = StatementsLoader.loadPath(logger, (String)op_yaml_loc.get(), this.activityDef.getParams(), new String[]{"activities"});
            workloadSource = "yaml:" + (String)op_yaml_loc.get();
        }
        List<OpTemplate> stmts = stmtsDocList.getStmts(tagfilter);
        ArrayList<Long> ratios = new ArrayList<Long>(stmts.size());
        for (i = 0; i < stmts.size(); ++i) {
            OpTemplate opTemplate = stmts.get(i);
            long ratio = ((Integer)opTemplate.removeParamOrDefault("ratio", (Object)1)).intValue();
            ratios.add(ratio);
        }
        if (stmts.size() == 0) {
            throw new BasicError("There were no active statements with tag filter '" + tagfilter + "'");
        }
        try {
            for (i = 0; i < stmts.size(); ++i) {
                long ratio = (Long)ratios.get(i);
                OpTemplate optemplate = stmts.get(i);
                OpDispenser<O> driverSpecificReadyOp = opinit.apply(optemplate);
                planner.addOp(driverSpecificReadyOp, ratio);
            }
        }
        catch (Exception e) {
            throw new OpConfigError("error while configuring op", (String)workloadSource, (Throwable)e);
        }
        return planner.resolve();
    }

    @Override
    public ProgressMeter getProgressMeter() {
        Input input = this.getInputDispenserDelegate().getInput(0L);
        if (input instanceof ProgressCapable) {
            ProgressMeter meter = ((ProgressCapable)((Object)input)).getProgressMeter();
            return new ProgressAndStateMeter(meter, this);
        }
        throw new RuntimeException("Progress meter must be implemented here.");
    }

    @Override
    public int getMaxTries() {
        return this.getActivityDef().getParams().getOptionalInteger("maxtries").orElse(10);
    }
}

