/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl.input;

import io.nosqlbench.engine.api.activityapi.core.ActivitiesAware;
import io.nosqlbench.engine.api.activityapi.core.Activity;
import io.nosqlbench.engine.api.activityapi.input.Input;
import io.nosqlbench.engine.api.activityapi.input.InputDispenser;
import io.nosqlbench.engine.api.activityapi.input.InputType;
import io.nosqlbench.engine.api.util.SimpleConfig;
import java.util.Map;

public class CoreInputDispenser
implements InputDispenser,
ActivitiesAware {
    private Activity activity;
    private Map<String, Activity> activities;
    private Input input;

    public CoreInputDispenser(Activity activity) {
        this.activity = activity;
    }

    @Override
    public Input getInput(long slot) {
        if (this.input == null) {
            this.input = this.createInput(slot);
        }
        return this.input;
    }

    private synchronized Input createInput(long slot) {
        SimpleConfig conf = new SimpleConfig(this.activity, "input");
        String inputType = conf.getString("type").orElse("atomicseq");
        InputType inputTypeImpl = (InputType)InputType.FINDER.getOrThrow(inputType);
        InputDispenser inputDispenser = inputTypeImpl.getInputDispenser(this.activity);
        if (inputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)inputDispenser)).setActivitiesMap(this.activities);
        }
        Input input = inputDispenser.getInput(slot);
        return input;
    }

    @Override
    public void setActivitiesMap(Map<String, Activity> activities) {
        this.activities = activities;
    }
}

