/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl.uniform;

import io.nosqlbench.engine.api.activityapi.errorhandling.modular.NBErrorHandler;
import io.nosqlbench.engine.api.activityapi.planning.OpSequence;
import io.nosqlbench.engine.api.activityapi.planning.OpSource;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.activityimpl.OpDispenser;
import io.nosqlbench.engine.api.activityimpl.OpMapper;
import io.nosqlbench.engine.api.activityimpl.SimpleActivity;
import io.nosqlbench.engine.api.activityimpl.uniform.DriverAdapter;
import io.nosqlbench.engine.api.activityimpl.uniform.flowtypes.Op;
import io.nosqlbench.nb.api.errors.OpConfigError;
import java.util.List;
import java.util.function.Function;

public class StandardActivity<R extends Op, S>
extends SimpleActivity {
    private final DriverAdapter<R, S> adapter;
    private final OpSource<R> opsource;
    private NBErrorHandler errorHandler;
    OpSequence<OpDispenser<R>> sequence;

    public StandardActivity(DriverAdapter<R, S> adapter, ActivityDef activityDef) {
        super(activityDef);
        this.adapter = adapter;
        try {
            OpMapper opmapper = adapter.getOpMapper();
            Function preprocessor = adapter.getPreprocessor();
            this.sequence = this.createOpSourceFromCommands(opmapper, adapter.getConfiguration(), List.of(preprocessor));
            this.opsource = OpSource.of(this.sequence);
        }
        catch (Exception e) {
            if (e instanceof OpConfigError) {
                throw e;
            }
            throw new OpConfigError("Error mapping workload template to operations: " + e.getMessage(), null, (Throwable)e);
        }
    }

    @Override
    public void initActivity() {
        super.initActivity();
        this.setDefaultsFromOpSequence(this.sequence);
    }

    public OpSource<R> getOpSource() {
        return this.opsource;
    }

    @Override
    public final Function<Throwable, String> getErrorNameMapper() {
        return this.adapter.getErrorNameMapper();
    }
}

