/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ExceptionTimerMetrics {
    private final ConcurrentHashMap<String, Timer> timers = new ConcurrentHashMap();
    private final ActivityDef activityDef;

    public ExceptionTimerMetrics(ActivityDef activityDef) {
        this.activityDef = activityDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String name, long nanosDuration) {
        Timer timer = this.timers.get(name);
        if (timer == null) {
            ConcurrentHashMap<String, Timer> concurrentHashMap = this.timers;
            synchronized (concurrentHashMap) {
                timer = this.timers.computeIfAbsent(name, k -> ActivityMetrics.timer((ActivityDef)this.activityDef, (String)("exceptions." + name)));
            }
        }
        timer.update(nanosDuration, TimeUnit.NANOSECONDS);
    }

    public List<Timer> getTimers() {
        return new ArrayList<Timer>(this.timers.values());
    }
}

