/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.scenarios;

import io.nosqlbench.engine.api.activityconfig.StatementsLoader;
import io.nosqlbench.engine.api.activityconfig.rawyaml.RawStmtsLoader;
import io.nosqlbench.engine.api.activityconfig.yaml.Scenarios;
import io.nosqlbench.engine.api.activityconfig.yaml.StmtsDocList;
import io.nosqlbench.engine.api.scenarios.WorkloadDesc;
import io.nosqlbench.engine.api.templating.StrInterpolator;
import io.nosqlbench.nb.api.config.params.Synonyms;
import io.nosqlbench.nb.api.content.Content;
import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.nb.api.content.NBPathsAPI;
import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBCLIScenarioParser {
    public static final String SILENT_LOCKED = "==";
    public static final String VERBOSE_LOCKED = "===";
    public static final String UNLOCKED = "=";
    private static final Logger logger = LogManager.getLogger((String)"SCENARIOS");
    private static final String SEARCH_IN = "activities";
    public static final String WORKLOAD_SCENARIO_STEP = "WORKLOAD_SCENARIO_STEP";
    private static final Pattern WordAndMaybeAssignment = Pattern.compile("(?<name>\\w[-_\\d\\w.]+)((?<oper>=+)(?<val>.+))?");
    private static final Pattern templatePattern = Pattern.compile("TEMPLATE\\((.+?)\\)");
    private static final Pattern innerTemplatePattern = Pattern.compile("TEMPLATE\\((.+?)$");
    private static final Pattern templatePattern2 = Pattern.compile("<<(.+?)>>");

    public static boolean isFoundWorkload(String workload, String ... includes) {
        Optional found = NBIO.all().prefix(new String[]{SEARCH_IN}).prefix(includes).name(new String[]{workload}).extension(RawStmtsLoader.YAML_EXTENSIONS).first();
        return found.isPresent();
    }

    public static void parseScenarioCommand(LinkedList<String> arglist, Set<String> RESERVED_WORDS, String ... includes) {
        String workloadName = arglist.removeFirst();
        Optional found = NBIO.all().prefix(new String[]{SEARCH_IN}).prefix(includes).name(new String[]{workloadName}).extension(RawStmtsLoader.YAML_EXTENSIONS).first();
        Content workloadContent = (Content)found.orElseThrow();
        ArrayList<String> scenarioNames = new ArrayList<String>();
        while (!(arglist.size() <= 0 || arglist.peekFirst().contains(UNLOCKED) || arglist.peekFirst().startsWith("-") || RESERVED_WORDS.contains(arglist.peekFirst()))) {
            scenarioNames.add(arglist.removeFirst());
        }
        if (scenarioNames.size() == 0) {
            scenarioNames.add("default");
        }
        LinkedHashMap<String, String> userProvidedParams = new LinkedHashMap<String, String>();
        while (arglist.size() > 0 && arglist.peekFirst().contains(UNLOCKED) && !arglist.peekFirst().startsWith("-")) {
            String[] arg = arglist.removeFirst().split(UNLOCKED, 2);
            arg[0] = Synonyms.canonicalize((String)arg[0], (Logger)logger);
            if (userProvidedParams.containsKey(arg[0])) {
                throw new BasicError("duplicate occurrence of option on command line: " + arg[0]);
            }
            userProvidedParams.put(arg[0], arg[1]);
        }
        LinkedList buildCmdBuffer = new LinkedList();
        StrInterpolator userParamsInterp = new StrInterpolator(userProvidedParams);
        for (String scenarioName : scenarioNames) {
            Content yamlWithNamedScenarios = (Content)NBIO.all().prefix(new String[]{SEARCH_IN}).prefix(includes).name(new String[]{workloadName}).extension(RawStmtsLoader.YAML_EXTENSIONS).first().orElseThrow();
            StmtsDocList scenariosYaml = StatementsLoader.loadContent(logger, yamlWithNamedScenarios, new LinkedHashMap<String, String>(userProvidedParams));
            Scenarios scenarios = scenariosYaml.getDocScenarios();
            Map<String, String> namedSteps = scenarios.getNamedScenario(scenarioName);
            if (namedSteps == null) {
                throw new BasicError("Unable to find named scenario '" + scenarioName + "' in workload '" + workloadName + "', but you can pick from one of: " + scenarios.getScenarioNames().stream().collect(Collectors.joining(", ")));
            }
            for (Map.Entry<String, String> cmdEntry : namedSteps.entrySet()) {
                String stepName = cmdEntry.getKey();
                String cmd = cmdEntry.getValue();
                cmd = userParamsInterp.apply(cmd);
                LinkedHashMap<String, CmdArg> parsedStep = NBCLIScenarioParser.parseStep(cmd);
                LinkedHashMap<String, String> usersCopy = new LinkedHashMap<String, String>(userProvidedParams);
                LinkedHashMap<String, Object> buildingCmd = new LinkedHashMap<String, Object>();
                for (CmdArg cmdarg : parsedStep.values()) {
                    if (usersCopy.containsKey(cmdarg.getName())) {
                        cmdarg = cmdarg.override((String)usersCopy.remove(cmdarg.getName()));
                    }
                    buildingCmd.put(cmdarg.getName(), cmdarg.toString());
                }
                usersCopy.forEach((k, v) -> buildingCmd.put((String)k, k + UNLOCKED + v));
                List<String> undefKeys = buildingCmd.entrySet().stream().filter(e -> ((String)e.getValue()).toLowerCase().endsWith("=undef")).map(Map.Entry::getKey).collect(Collectors.toList());
                undefKeys.forEach(buildingCmd::remove);
                if (!buildingCmd.containsKey("workload")) {
                    buildingCmd.put("workload", "workload=" + workloadName);
                }
                if (!buildingCmd.containsKey("alias")) {
                    buildingCmd.put("alias", "alias=WORKLOAD_SCENARIO_STEP");
                }
                Object alias = (String)buildingCmd.get("alias");
                for (String token : new String[]{"WORKLOAD", "SCENARIO", "STEP"}) {
                    if (((String)alias).contains(token)) continue;
                    logger.warn("Your alias template '" + (String)alias + "' does not contain " + token + ", which will cause your metrics to be combined under the same name. It is strongly advised that you include them in a template like WORKLOAD_SCENARIO_STEP.");
                }
                String workloadToken = workloadContent.asPath().getFileName().toString();
                alias = ((String)alias).replaceAll("WORKLOAD", NBCLIScenarioParser.sanitize(workloadToken));
                alias = ((String)alias).replaceAll("SCENARIO", NBCLIScenarioParser.sanitize(scenarioName));
                alias = ((String)(alias = ((String)alias).replaceAll("STEP", NBCLIScenarioParser.sanitize(stepName)))).startsWith("alias=") ? alias : "alias=" + (String)alias;
                buildingCmd.put("alias", alias);
                logger.debug("rebuilt command: " + String.join((CharSequence)" ", buildingCmd.values()));
                buildCmdBuffer.addAll(buildingCmd.values());
            }
        }
        buildCmdBuffer.descendingIterator().forEachRemaining(arglist::addFirst);
    }

    public static String sanitize(String word) {
        String sanitized = word;
        sanitized = sanitized.replaceAll("\\..+$", "");
        sanitized = sanitized.replaceAll("[^a-zA-Z0-9]+", "");
        return sanitized;
    }

    private static LinkedHashMap<String, CmdArg> parseStep(String cmd) {
        String[] namedStepPieces;
        LinkedHashMap<String, CmdArg> parsedStep = new LinkedHashMap<String, CmdArg>();
        for (String commandFragment : namedStepPieces = cmd.split(" ")) {
            Matcher matcher = WordAndMaybeAssignment.matcher(commandFragment);
            if (!matcher.matches()) {
                throw new BasicError("Unable to recognize scenario cmd spec in '" + commandFragment + "'");
            }
            String commandName = matcher.group("name");
            commandName = Synonyms.canonicalize((String)commandName, (Logger)logger);
            String assignmentOp = matcher.group("oper");
            String assignedValue = matcher.group("val");
            parsedStep.put(commandName, new CmdArg(commandName, assignmentOp, assignedValue));
        }
        return parsedStep;
    }

    public static List<WorkloadDesc> filterForScenarios(List<Content<?>> candidates) {
        List yamlPathList = candidates.stream().map(Content::asPath).collect(Collectors.toList());
        ArrayList<WorkloadDesc> workloadDescriptions = new ArrayList<WorkloadDesc>();
        for (Path yamlPath : yamlPathList) {
            try {
                Content content;
                StmtsDocList stmts;
                Path relative;
                String referenced = yamlPath.toString();
                if (referenced.startsWith("/") && yamlPath.getFileSystem() == FileSystems.getDefault() && !(relative = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath().relativize(yamlPath)).toString().contains("..")) {
                    referenced = relative.toString();
                }
                if ((stmts = StatementsLoader.loadContent(logger, content = NBIO.all().prefix(new String[]{SEARCH_IN}).name(new String[]{referenced}).extension(RawStmtsLoader.YAML_EXTENSIONS).one(), Map.of())).getStmtDocs().size() == 0) {
                    logger.warn("Encountered yaml with no docs in '" + referenced + "'");
                    continue;
                }
                Map<String, String> templates = new LinkedHashMap<String, String>();
                try {
                    List<String> lines = Files.readAllLines(yamlPath);
                    for (String line : lines) {
                        templates = NBCLIScenarioParser.matchTemplates(line, templates);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Scenarios scenarios = stmts.getDocScenarios();
                List<String> scenarioNames = scenarios.getScenarioNames();
                if (scenarioNames == null || scenarioNames.size() <= 0) continue;
                LinkedHashMap<String, String> sortedTemplates = new LinkedHashMap<String, String>();
                ArrayList<String> keyNames = new ArrayList<String>(templates.keySet());
                Collections.sort(keyNames);
                for (String keyName : keyNames) {
                    sortedTemplates.put(keyName, templates.get(keyName));
                }
                String description = stmts.getDescription();
                workloadDescriptions.add(new WorkloadDesc(referenced, scenarioNames, sortedTemplates, description, ""));
            }
            catch (Exception e) {
                throw new RuntimeException("Error while scanning path '" + yamlPath.toString() + "':" + e.getMessage(), e);
            }
        }
        Collections.sort(workloadDescriptions);
        return workloadDescriptions;
    }

    public static List<WorkloadDesc> getWorkloadsWithScenarioScripts(boolean defaultIncludes, Set<String> includes) {
        return NBCLIScenarioParser.getWorkloadsWithScenarioScripts(defaultIncludes, includes.toArray(new String[0]));
    }

    public static List<WorkloadDesc> getWorkloadsWithScenarioScripts(boolean defaultIncludes, String ... includes) {
        NBPathsAPI.GetPrefix searchin = NBIO.all();
        if (defaultIncludes) {
            searchin = searchin.prefix(new String[]{SEARCH_IN});
        }
        List activities = searchin.prefix(includes).extension(RawStmtsLoader.YAML_EXTENSIONS).list();
        return NBCLIScenarioParser.filterForScenarios(activities);
    }

    public static List<String> getScripts(boolean defaultIncludes, String ... includes) {
        NBPathsAPI.GetPrefix searchin = NBIO.all();
        if (defaultIncludes) {
            searchin = searchin.prefix(new String[]{SEARCH_IN});
        }
        List scriptPaths = searchin.prefix(new String[]{"scripts/auto"}).prefix(includes).extension(new String[]{"js"}).list().stream().map(Content::asPath).collect(Collectors.toList());
        ArrayList<String> scriptNames = new ArrayList<String>();
        for (Path scriptPath : scriptPaths) {
            String name = scriptPath.getFileName().toString();
            name = name.substring(0, name.lastIndexOf(46));
            scriptNames.add(name);
        }
        return scriptNames;
    }

    public static Map<String, String> matchTemplates(String line, Map<String, String> templates) {
        String match;
        Matcher matcher = templatePattern.matcher(line);
        while (matcher.find()) {
            match = matcher.group(1);
            Matcher innerMatcher = innerTemplatePattern.matcher(match);
            String[] matchArray = match.split(",");
            if (innerMatcher.find()) {
                String[] innerMatch = innerMatcher.group(1).split("[,:]");
                templates.put(matchArray[0], innerMatch[1]);
                continue;
            }
            templates.put(matchArray[0], matchArray[1]);
        }
        matcher = templatePattern2.matcher(line);
        while (matcher.find()) {
            match = matcher.group(1);
            String[] matchArray = match.split(":");
            if (matchArray.length == 1) {
                templates.put(matchArray[0], "-none-");
                continue;
            }
            templates.put(matchArray[0], matchArray[1]);
        }
        return templates;
    }

    private static final class CmdArg {
        private final String name;
        private final String operator;
        private final String value;
        private String scenarioName;

        public CmdArg(String name, String operator, String value) {
            this.name = name;
            this.operator = operator;
            this.value = value;
        }

        public boolean isReassignable() {
            return NBCLIScenarioParser.UNLOCKED.equals(this.operator);
        }

        public boolean isFinalSilent() {
            return NBCLIScenarioParser.SILENT_LOCKED.equals(this.operator);
        }

        public boolean isFinalVerbose() {
            return NBCLIScenarioParser.VERBOSE_LOCKED.equals(this.operator);
        }

        public CmdArg override(String value) {
            if (this.isReassignable()) {
                return new CmdArg(this.name, this.operator, value);
            }
            if (this.isFinalSilent()) {
                return this;
            }
            if (this.isFinalVerbose()) {
                throw new BasicError("Unable to reassign value for locked param '" + this.name + this.operator + value + "'");
            }
            throw new RuntimeException("impossible!");
        }

        public String toString() {
            return this.name + (this.operator != null ? NBCLIScenarioParser.UNLOCKED : "") + (this.value != null ? this.value : "");
        }

        public String getName() {
            return this.name;
        }
    }
}

