/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.scenarios;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class WorkloadDesc
implements Comparable<WorkloadDesc> {
    private final String workspace;
    private final String yamlPath;
    private final List<String> scenarioNames;
    private final Map<String, String> templates;
    private final String description;

    public WorkloadDesc(String yamlPath, List<String> scenarioNames, Map<String, String> templates, String description, String workspace) {
        this.yamlPath = yamlPath;
        this.scenarioNames = scenarioNames;
        this.templates = templates;
        this.description = description;
        this.workspace = workspace;
    }

    public String getYamlPath() {
        return this.yamlPath;
    }

    public String getWorkloadName() {
        return this.getYamlPath().replaceAll("\\.yaml", "");
    }

    public List<String> getScenarioNames() {
        return this.scenarioNames;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public String toString() {
        return (String)(this.workspace != null && !this.workspace.isEmpty() ? this.workspace + ":" : "") + this.yamlPath;
    }

    public String toMarkdown(boolean includeScenarios) {
        StringBuilder sb = new StringBuilder();
        if (this.description.isEmpty()) {
            sb.append("# no description provided\n");
        }
        if (!this.description.isEmpty()) {
            String formattedDesc = "# " + this.description.split("[\n.;]")[0];
            sb.append(formattedDesc).append("\n");
            while (sb.toString().endsWith("\n\n")) {
                sb.setLength(sb.length() - 1);
            }
        }
        if (includeScenarios) {
            sb.append("# workload found in ");
        }
        sb.append(this.getYamlPath()).append("\n");
        if (includeScenarios) {
            sb.append("    # scenarios:\n");
            for (String string : this.getScenarioNames()) {
                sb.append("    nb ").append(this.getWorkloadName()).append(" ").append(string).append("\n");
            }
            if (this.templates.size() > 0) {
                sb.append("        # defaults\n");
            }
            for (Map.Entry entry : this.templates.entrySet()) {
                sb.append("        ").append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(@NotNull WorkloadDesc o) {
        return this.yamlPath.compareTo(o.yamlPath);
    }

    public WorkloadDesc relativize(Path wsPath) {
        Path yPath = Paths.get(this.yamlPath, new String[0]).toAbsolutePath();
        Path relativePath = wsPath.relativize(yPath);
        String wsName = wsPath.getFileName().toString();
        return new WorkloadDesc(relativePath.toString(), this.scenarioNames, this.templates, this.description, wsName);
    }

    public String getWorkspace() {
        return this.workspace;
    }
}

