/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.scoping;

import java.util.function.Supplier;

public enum ScopedSupplier {
    singleton,
    thread,
    caller;


    public <T> Supplier<T> supplier(Supplier<T> supplier) {
        switch (this) {
            case singleton: {
                Object got = supplier.get();
                return () -> got;
            }
            case thread: {
                ThreadLocal<T> tlsupplier = ThreadLocal.withInitial(supplier);
                return tlsupplier::get;
            }
            case caller: {
                return supplier;
            }
        }
        throw new RuntimeException("Unknown scope type:" + this);
    }
}

