/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.scripting;

import io.nosqlbench.engine.api.scripting.ExprEvaluator;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.EnvironmentAccess;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalJsEvaluator<T>
implements ExprEvaluator<T> {
    private final Class<T> resultType;
    private Context context;
    private Source script;

    public GraalJsEvaluator(Class<T> resultType) {
        this.resultType = resultType;
    }

    private Context getContext() {
        if (this.context == null) {
            Context.Builder contextSettings = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(HostAccess.ALL).allowNativeAccess(true).allowCreateThread(true).allowIO(true).allowHostClassLookup(s -> true).allowHostClassLoading(true).allowCreateProcess(true).allowAllAccess(true).allowEnvironmentAccess(EnvironmentAccess.INHERIT).allowPolyglotAccess(PolyglotAccess.ALL).option("js.ecmascript-version", "2020").option("js.nashorn-compat", "true");
            this.context = contextSettings.build();
        }
        return this.context;
    }

    @Override
    public T eval() {
        Value result = this.getContext().eval(this.script);
        Object asType = result.as(this.resultType);
        return (T)asType;
    }

    @Override
    public ExprEvaluator<T> script(String scriptText) {
        this.script = Source.create((String)"js", (CharSequence)scriptText);
        return this;
    }

    @Override
    public ExprEvaluator<T> put(String varName, Object var) {
        this.getContext().getBindings("js").putMember(varName, var);
        return this;
    }
}

