/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.templating;

import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.nb.api.config.params.ParamsParser;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.core.bindings.BindingsTemplate;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import io.nosqlbench.virtdata.core.templates.StringBindings;
import io.nosqlbench.virtdata.core.templates.StringBindingsTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated(forRemoval=true)
public class CommandTemplate {
    private static final Logger logger = LogManager.getLogger(CommandTemplate.class);
    private final String name;
    private final Map<String, String> statics = new HashMap<String, String>();
    private final Map<String, StringBindings> dynamics = new HashMap<String, StringBindings>();
    private final transient int mapsize;

    public CommandTemplate(OpTemplate optpl) {
        this(optpl.getName(), optpl.getOp().toString(), optpl.getParamsAsValueType(String.class), optpl.getBindings(), List.of());
    }

    public CommandTemplate(OpTemplate optpl, List<Function<String, Map<String, String>>> parsers) {
        this(optpl.getName(), (String)optpl.getStmt().orElseThrow(), optpl.getParamsAsValueType(String.class), optpl.getBindings(), parsers);
    }

    public CommandTemplate(String name, String op, Map<String, String> params, Map<String, String> bindings, List<Function<String, Map<String, String>>> optionalParsers) {
        this.name = name;
        HashMap<String, String> cmd = new HashMap<String, String>();
        if (!(op instanceof CharSequence)) {
            throw new BasicError("Unable to create a oneline version of the CommandTemplate with op type of " + op.getClass().getSimpleName());
        }
        String oneline = op;
        if (oneline != null) {
            ArrayList<Function<String, Map<String, String>>> parserlist = new ArrayList<Function<String, Map<String, String>>>(optionalParsers);
            parserlist.add(s -> ParamsParser.parse((String)s, (boolean)false));
            boolean didParse = false;
            for (Function function : parserlist) {
                Map parsed = (Map)function.apply(oneline);
                if (parsed == null) continue;
                logger.debug("parsed request: " + parsed);
                cmd.putAll(parsed);
                didParse = true;
                break;
            }
            if (!didParse) {
                throw new RuntimeException("A oneline form was provided for the command template, but none of the provided parsers were able to parse it, not even ParamsParser.parse(...)");
            }
        }
        params.forEach((k, v) -> {
            if (cmd.containsKey(k)) {
                logger.warn("command property override: '" + k + "' superseded by param form with value '" + v + "'");
            }
        });
        cmd.putAll(params);
        cmd.forEach((param, value) -> {
            ParsedTemplate paramTemplate = new ParsedTemplate(value, bindings);
            if (paramTemplate.getBindPoints().size() > 0) {
                BindingsTemplate paramBindings = new BindingsTemplate(paramTemplate.getBindPoints());
                StringBindings paramStringBindings = new StringBindingsTemplate(value, paramBindings).resolve();
                this.dynamics.put((String)param, paramStringBindings);
            } else {
                this.statics.put((String)param, (String)value);
            }
        });
        this.mapsize = this.statics.size() + this.dynamics.size();
    }

    public Map<String, String> getCommand(long cycle) {
        HashMap<String, String> map = new HashMap<String, String>(this.mapsize);
        map.putAll(this.statics);
        this.dynamics.forEach((k, v) -> map.put((String)k, v.bind(cycle)));
        return map;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStatic() {
        return this.dynamics.size() == 0;
    }

    public boolean isStatic(String keyname) {
        return this.statics.containsKey(keyname);
    }

    public boolean isStaticSet(String ... keynames) {
        for (String keyname : keynames) {
            if (this.isStatic(keyname)) continue;
            return false;
        }
        return true;
    }

    public boolean isDynamicSet(String ... keynames) {
        for (String keyname : keynames) {
            if (this.isDynamic(keyname)) continue;
            return false;
        }
        return true;
    }

    public boolean isDynamic(String keyname) {
        return this.dynamics.containsKey(keyname);
    }

    public boolean containsKey(String keyname) {
        return this.statics.containsKey(keyname) || this.dynamics.containsKey(keyname);
    }

    public Set<String> getPropertyNames() {
        return this.statics.keySet();
    }

    public String toString() {
        return "CommandTemplate{name='" + this.name + "', statics=" + this.statics + ", dynamics=" + this.dynamics + "}";
    }

    public String getStatic(String staticVar) {
        return this.statics.get(staticVar);
    }

    public String getDynamic(String dynamicVar, long input) {
        return this.dynamics.get(dynamicVar).bind(input);
    }

    public String get(String var, long input) {
        if (this.statics.containsKey(var)) {
            return this.statics.get(var);
        }
        if (this.dynamics.containsKey(var)) {
            return this.dynamics.get(var).bind(input);
        }
        return null;
    }

    public String getOr(String var, long input, String defaultVal) {
        if (this.statics.containsKey(var)) {
            return this.statics.get(var);
        }
        if (this.dynamics.containsKey(var)) {
            return this.dynamics.get(var).bind(input);
        }
        return defaultVal;
    }

    public String getStaticOr(String staticVar, String defaultVal) {
        if (this.statics.containsKey(staticVar)) {
            return this.statics.get(staticVar);
        }
        return defaultVal;
    }

    public String getDynamicOr(String dynamicVar, long input, String defaultVal) {
        if (this.dynamics.containsKey(dynamicVar)) {
            return this.getDynamic(dynamicVar, input);
        }
        return defaultVal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandTemplate that = (CommandTemplate)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.statics, that.statics) && Objects.equals(this.dynamics, that.dynamics);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.statics, this.dynamics);
    }

    public boolean containsAny(String ... varNames) {
        for (String varName : varNames) {
            if (!this.containsKey(varName)) continue;
            return true;
        }
        return false;
    }

    public boolean isStaticOrUnsetSet(String ... varnames) {
        for (String varname : varnames) {
            if (!this.isDynamic(varname)) continue;
            return false;
        }
        return true;
    }

    public String getFieldDescription(String varname) {
        if (this.isDynamic(varname)) {
            return "dynamic: " + this.dynamics.get(varname).toString();
        }
        if (this.isStatic(varname)) {
            return "static: " + this.getStatic(varname);
        }
        return "UNDEFINED";
    }
}

