/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.templating;

import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StrLookup;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StrInterpolator
implements Function<String, String> {
    private static final Logger logger = LogManager.getLogger(StrInterpolator.class);
    private final MultiMap multimap = new MultiMap();
    private final StringSubstitutor substitutor = new StringSubstitutor((StringLookup)this.multimap, "<<", ">>", '\\').setEnableSubstitutionInVariables(true).setEnableUndefinedVariableException(true).setDisableSubstitutionInValues(true);
    private final StringSubstitutor substitutor2 = new StringSubstitutor((StringLookup)this.multimap, "TEMPLATE(", ")", '\\').setEnableSubstitutionInVariables(true).setEnableUndefinedVariableException(true).setDisableSubstitutionInValues(true);

    public StrInterpolator(ActivityDef ... activityDefs) {
        Arrays.stream(activityDefs).map(ad -> ad.getParams().getStringStringMap()).forEach(this.multimap::add);
    }

    public StrInterpolator(Map<String, ?> basicMap) {
        this.multimap.add(basicMap);
    }

    protected StrInterpolator(List<Map<String, String>> maps) {
        maps.forEach(this.multimap::add);
    }

    @Override
    public String apply(String raw) {
        String after = this.substitutor.replace(this.substitutor2.replace(raw));
        while (!after.equals(raw)) {
            raw = after;
            after = this.substitutor.replace(this.substitutor2.replace(raw));
        }
        return after;
    }

    public Map<String, String> checkpointAccesses() {
        return this.multimap.checkpointAccesses();
    }

    public LinkedHashMap<String, String> getTemplateDetails(String input) {
        LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
        return details;
    }

    public static class MultiMap
    extends StrLookup<String> {
        private final List<Map<String, ?>> maps = new ArrayList();
        private final String warnPrefix = "UNSET";
        private final Map<String, String> accesses = new LinkedHashMap<String, String>();
        private final Map<String, String> extractedDefaults = new LinkedHashMap<String, String>();

        public void add(Map<String, ?> addedMap) {
            this.maps.add(addedMap);
        }

        public String lookup(String key) {
            Object value = null;
            String[] parts = key.split("[:,]", 2);
            if (parts.length == 2) {
                key = parts[0];
                value = parts[1];
                if (!this.extractedDefaults.containsKey(key)) {
                    this.extractedDefaults.put(key, (String)value);
                }
            }
            for (Map<String, ?> map : this.maps) {
                Object val = map.get(key);
                if (val == null) continue;
                value = val.toString();
                break;
            }
            value = value == null ? this.extractedDefaults.get(key) : value;
            value = value != null ? value : "UNSET:" + key;
            this.accesses.put(key, (String)value);
            logger.debug("Template parameter '" + key + "' applied as '" + (String)value + "'");
            return value;
        }

        public Map<String, String> checkpointAccesses() {
            LinkedHashMap<String, String> accesses = new LinkedHashMap<String, String>(this.accesses);
            logger.info("removed template params after applying:" + accesses);
            this.accesses.clear();
            return accesses;
        }
    }
}

