/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.util;

import io.nosqlbench.engine.api.activityapi.core.Activity;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SimpleConfig {
    private final Map<String, String> params;

    public SimpleConfig(String configdata) {
        this.params = this.parseParams(configdata);
    }

    public SimpleConfig(Activity activity, String param) {
        this(activity.getParams().getOptionalString(new String[]{param}).orElse(""));
    }

    private Map<String, String> parseParams(String configdata) {
        try {
            return Arrays.stream(configdata.split("[,]")).filter(Objects::nonNull).filter(s -> !s.isEmpty()).map(s -> s.split("[:=]")).collect(Collectors.toMap(o -> o[0], o -> o[1]));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse params: '" + configdata + "': " + e);
        }
    }

    public Optional<String> getString(String name) {
        return Optional.ofNullable(this.params.get(name));
    }

    public Optional<Integer> getInteger(String name) {
        return Optional.ofNullable(this.params.get(name)).map(Integer::valueOf);
    }

    public Optional<Long> getLong(String name) {
        return Optional.ofNullable(this.params.get(name)).map(Long::valueOf);
    }

    public Optional<Double> getDouble(String name) {
        return Optional.ofNullable(this.params.get(name)).map(Double::valueOf);
    }
}

