/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.util;

import io.nosqlbench.engine.api.util.Tagged;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TagFilter {
    public static TagFilter MATCH_ALL = new TagFilter("");
    private final Map<String, String> filter = new LinkedHashMap<String, String>();
    private Conjugate conjugate = Conjugate.all;
    private static final Pattern conjugateForm = Pattern.compile("^(?<conjugate>\\w+)\\((?<filter>.+)\\)$", 40);

    public TagFilter(String filterSpec) {
        if (filterSpec != null && !filterSpec.isEmpty()) {
            String[] keyvalues;
            Matcher cmatcher = conjugateForm.matcher(filterSpec = TagFilter.unquote(filterSpec));
            if (cmatcher.matches()) {
                filterSpec = cmatcher.group("filter");
                this.conjugate = Conjugate.valueOf(cmatcher.group("conjugate").toLowerCase());
            }
            for (String assignment : keyvalues = filterSpec.split("[,] *")) {
                String value;
                String[] keyvalue = assignment.split("[:=]", 2);
                String key = keyvalue[0];
                String string = value = keyvalue.length > 1 ? keyvalue[1] : null;
                if (value != null) {
                    value = TagFilter.unquote(value);
                    value = value.trim();
                }
                this.filter.put(key, value);
            }
        }
    }

    private static String unquote(String filterSpec) {
        for (String s : new String[]{"'", "\""}) {
            if (filterSpec.indexOf(s) != 0 || filterSpec.indexOf(s, 1) != filterSpec.length() - 1) continue;
            filterSpec = filterSpec.substring(1, filterSpec.length() - 1);
        }
        return filterSpec;
    }

    protected Result matches(Map<String, String> tags) {
        ArrayList<String> log = new ArrayList<String>();
        int totalKeyMatches = 0;
        for (String filterkey : this.filter.keySet()) {
            boolean matchedKey = true;
            String filterval = this.filter.get(filterkey);
            String itemval = tags.get(filterkey);
            String detail = "filter(" + filterkey + (String)(filterval != null ? ":" + filterval : "") + ") tag(" + (tags.containsKey(filterkey) ? filterkey : "") + (String)(tags.get(filterkey) != null ? ":" + tags.get(filterkey) : "") + ")";
            if (filterval == null) {
                if (tags.containsKey(filterkey)) {
                    log.add("(\u2611, ) " + detail + ": matched names");
                } else {
                    log.add("(\u2610, ) " + detail + ": did not match)");
                    matchedKey = false;
                }
            } else {
                Pattern filterpattern = Pattern.compile("^" + filterval + "$");
                if (itemval == null) {
                    log.add("(\u2611,\u2610) " + detail + ": null tag value did not match '" + filterpattern + "'");
                    matchedKey = false;
                } else if (filterpattern.matcher(itemval).matches()) {
                    log.add("(\u2611,\u2611) " + detail + ": matched pattern '" + filterpattern + "'");
                } else {
                    log.add("(\u2611,\u2610) " + detail + ": did not match '" + filterpattern + "'");
                    matchedKey = false;
                }
            }
            totalKeyMatches += matchedKey ? 1 : 0;
        }
        boolean matched = this.conjugate.matchfunc.apply(this.filter.size(), totalKeyMatches);
        return new Result(matched, log);
    }

    public Result matchesMap(Map<String, String> tags) {
        return this.matches(tags);
    }

    public Result matchesTaggedResult(Tagged item) {
        return this.matches(item.getTags());
    }

    public boolean matchesTagged(Tagged item) {
        return this.matches(item.getTags()).matched();
    }

    public Map<String, String> getMap() {
        return this.filter;
    }

    private static enum Conjugate {
        any((i, j) -> j > 0),
        all((i, j) -> i.intValue() == j.intValue()),
        none((i, j) -> j == 0);

        private final BiFunction<Integer, Integer, Boolean> matchfunc;

        private Conjugate(BiFunction<Integer, Integer, Boolean> matchfunc) {
            this.matchfunc = matchfunc;
        }
    }

    public static class Result {
        private final boolean matched;
        private final List<String> matchLog;

        public Result(boolean matched, List<String> log) {
            this.matched = matched;
            this.matchLog = log;
        }

        public static Result Matched(final String reason) {
            return new Result(true, (List<String>)new ArrayList<String>(){
                {
                    this.add(reason);
                }
            });
        }

        public static Result Unmatched(final String reason) {
            return new Result(false, (List<String>)new ArrayList<String>(){
                {
                    this.add(reason);
                }
            });
        }

        public boolean matched() {
            return this.matched;
        }

        public String getLog() {
            return this.matchLog.stream().collect(Collectors.joining("\n"));
        }
    }
}

