/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.annotations;

import io.nosqlbench.nb.annotations.Service;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class ServiceProcessor
extends AbstractProcessor {
    public static final String SERVICE_NAME = Service.class.getCanonicalName();
    private static final Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private final Map<String, Writer> writers = new HashMap<String, Writer>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotations = new HashSet<String>();
        supportedAnnotations.add(SERVICE_NAME);
        return supportedAnnotations;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.options = processingEnv.getOptions();
        this.elementUtils = processingEnv.getElementUtils();
        this.messenger = processingEnv.getMessager();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    private Writer getWriterForClass(String className, Element ... elements) {
        return this.writers.computeIfAbsent(className, s -> {
            try {
                return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + s, elements).openWriter();
            }
            catch (IOException e) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, e.toString());
                return null;
            }
        });
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            for (String annotationType : this.getSupportedAnnotationTypes()) {
                Class<?> annotationClass = Class.forName(annotationType);
                Set<? extends Element> tsms = roundEnv.getElementsAnnotatedWith(annotationClass);
                for (Element element : tsms) {
                    String serviceClass = null;
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        DeclaredType atype = annotationMirror.getAnnotationType();
                        if (!annotationType.equals(atype.toString())) continue;
                        List valueKeys = annotationMirror.getElementValues().keySet().stream().filter(k -> k.toString().equals("value()")).collect(Collectors.toList());
                        if (valueKeys.size() == 0) {
                            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Annotation missing required value");
                            return false;
                        }
                        AnnotationValue annotationValue = annotationMirror.getElementValues().get(valueKeys.get(0));
                        serviceClass = annotationValue.getValue().toString();
                    }
                    Writer w = this.getWriterForClass(serviceClass, tsms.toArray(new Element[0]));
                    Name name = ((TypeElement)element).getQualifiedName();
                    this.messenger.printMessage(Diagnostic.Kind.NOTE, "Adding service entry for implementation of " + serviceClass + ": " + name);
                    w.write(name + "\n");
                }
            }
            for (Writer writer : this.writers.values()) {
                writer.close();
            }
        }
        catch (Exception e) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, e.toString());
        }
        return true;
    }
}

