/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import io.nosqlbench.engine.api.metrics.CapabilityHook;
import io.nosqlbench.engine.api.metrics.HistogramAttachment;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassicHistoListener
extends CapabilityHook<HistogramAttachment> {
    private static final Logger logger = LogManager.getLogger(ClassicHistoListener.class);
    private final MetricRegistry metricsRegistry;
    private final String sessionName;
    private final String prefix;
    private final Pattern pattern;
    private final String interval;
    private final TimeUnit nanoseconds;
    private final Map<String, Attachment> histos = new HashMap<String, Attachment>();

    public ClassicHistoListener(MetricRegistry metricRegistry, String sessionName, String prefix, Pattern pattern, String interval, TimeUnit nanoseconds) {
        this.metricsRegistry = metricRegistry;
        this.sessionName = sessionName;
        this.prefix = prefix;
        this.pattern = pattern;
        this.interval = interval;
        this.nanoseconds = nanoseconds;
    }

    @Override
    public void onCapableAdded(String name, HistogramAttachment capable) {
        if (this.pattern.matcher(name).matches()) {
            String prefixed = this.prefix + "-" + name;
            Histogram classicHisto = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
            capable.attachHistogram(classicHisto);
            this.histos.put(prefixed, new Attachment(name, this.prefix, capable, classicHisto));
            this.metricsRegistry.histogram(prefixed, () -> classicHisto);
            logger.trace("Added classic histogram attachment:" + prefixed);
        }
    }

    @Override
    public void onCapableRemoved(String name, HistogramAttachment capable) {
        Attachment removed = this.histos.remove(name);
        logger.trace("Removed classic histogram attachment: " + removed);
    }

    @Override
    protected Class<HistogramAttachment> getCapabilityClass() {
        return HistogramAttachment.class;
    }

    private static class Attachment {
        public final String upstreamName;
        public final HistogramAttachment upstream;
        public Histogram downstream;
        public String prefix;

        public Attachment(String upstreamName, String prefix, HistogramAttachment upstream, Histogram downstream) {
            this.prefix = prefix;
            this.upstreamName = upstreamName;
            this.upstream = upstream;
            this.downstream = downstream;
        }

        public String toString() {
            return "name:" + this.upstreamName + "->" + this.prefix + "-" + this.upstreamName;
        }

        public String getName() {
            return this.upstreamName;
        }
    }
}

