/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import io.nosqlbench.engine.api.metrics.DeltaHistogramSnapshot;
import org.HdrHistogram.EncodableHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramLogWriter;
import org.HdrHistogram.Recorder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DeltaHdrHistogramReservoir
implements Reservoir {
    private static final Logger logger = LogManager.getLogger(DeltaHdrHistogramReservoir.class);
    private final Recorder recorder;
    private Histogram lastHistogram;
    private Histogram intervalHistogram;
    private long intervalHistogramEndTime = System.currentTimeMillis();
    private final String metricName;
    private HistogramLogWriter writer;

    public DeltaHdrHistogramReservoir(String name, int significantDigits) {
        this.metricName = name;
        this.recorder = new Recorder(significantDigits);
        this.intervalHistogram = this.recorder.getIntervalHistogram();
        this.lastHistogram = new Histogram(this.intervalHistogram.getNumberOfSignificantValueDigits());
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public void update(long value) {
        this.recorder.recordValue(value);
    }

    public Snapshot getSnapshot() {
        this.lastHistogram = this.getNextHdrHistogram();
        return new DeltaHistogramSnapshot(this.lastHistogram);
    }

    public Histogram getNextHdrHistogram() {
        return this.getDataSinceLastSnapshotAndUpdate();
    }

    public Snapshot getLastSnapshot() {
        return new DeltaHistogramSnapshot(this.lastHistogram);
    }

    private synchronized Histogram getDataSinceLastSnapshotAndUpdate() {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        long intervalHistogramStartTime = this.intervalHistogramEndTime;
        this.intervalHistogramEndTime = System.currentTimeMillis();
        this.intervalHistogram.setTag(this.metricName);
        this.intervalHistogram.setStartTimeStamp(intervalHistogramStartTime);
        this.intervalHistogram.setEndTimeStamp(this.intervalHistogramEndTime);
        this.lastHistogram = this.intervalHistogram.copy();
        this.lastHistogram.setTag(this.metricName);
        if (this.writer != null) {
            this.writer.outputIntervalHistogram((EncodableHistogram)this.lastHistogram);
        }
        return this.lastHistogram;
    }

    public void write(HistogramLogWriter writer) {
        writer.outputIntervalHistogram((EncodableHistogram)this.lastHistogram);
    }

    public DeltaHdrHistogramReservoir copySettings() {
        return new DeltaHdrHistogramReservoir(this.metricName, this.intervalHistogram.getNumberOfSignificantValueDigits());
    }

    public void attachLogWriter(HistogramLogWriter logWriter) {
        this.writer = logWriter;
    }

    public Histogram getLastHistogram() {
        return this.lastHistogram;
    }
}

