/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

final class DeltaHistogramSnapshot
extends Snapshot {
    private final Histogram histogram;

    DeltaHistogramSnapshot(Histogram histogram) {
        this.histogram = histogram;
    }

    public double getValue(double quantile) {
        return this.histogram.getValueAtPercentile(quantile * 100.0);
    }

    public long[] getValues() {
        long[] vals = new long[(int)this.histogram.getTotalCount()];
        int i = 0;
        for (HistogramIterationValue value : this.histogram.recordedValues()) {
            long val = value.getValueIteratedTo();
            int j = 0;
            while ((long)j < value.getCountAddedInThisIterationStep()) {
                vals[i] = val;
                ++i;
                ++j;
            }
        }
        if (i != vals.length) {
            throw new IllegalStateException("Total count was " + this.histogram.getTotalCount() + " but iterating values produced " + vals.length);
        }
        return vals;
    }

    public int size() {
        return (int)this.histogram.getTotalCount();
    }

    public long getMax() {
        return this.histogram.getMaxValue();
    }

    public double getMean() {
        return this.histogram.getMean();
    }

    public long getMin() {
        return this.histogram.getMinValue();
    }

    public double getStdDev() {
        return this.histogram.getStdDeviation();
    }

    public void dump(OutputStream output) {
        try (PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    p.printf("%d%n", value.getValueIteratedTo());
                    ++j;
                }
            }
        }
    }

    private String getPctlSummary(double ... percentiles) {
        StringBuilder sb = new StringBuilder();
        for (double percentile : percentiles) {
            sb.append(String.format("%.3f", this.getValue(percentile))).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String toString() {
        return String.format(" (count, mean, min, max) = (%d, %.3f, %d, %d)\n", this.getValues().length, this.getMean(), this.getMin(), this.getMax()) + "         p(25,50,75) = (" + this.getPctlSummary(0.25, 0.5, 0.75) + ")\n p(90,99,9.99,99.99) = (" + this.getPctlSummary(0.9, 0.99, 0.999, 0.9999) + ")";
    }
}

