/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HistoStatsCSVWriter {
    private static final Logger logger = LogManager.getLogger(HistoStatsCSVWriter.class);
    private static final String logFormatVersion = "1.0";
    private final File csvfile;
    PrintStream writer;
    private long baseTime;

    public HistoStatsCSVWriter(File csvFile) {
        this.csvfile = csvFile;
        this.writer = this.initFile(csvFile);
    }

    private PrintStream initFile(File logfile) {
        try {
            PrintStream writer = new PrintStream(logfile);
            return writer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setBaseTime(long baseTime) {
        this.baseTime = baseTime;
    }

    public void outputComment(String comment) {
        this.writer.format(Locale.US, "#%s\n", comment);
    }

    public void outputLogFormatVersion() {
        this.writer.format(Locale.US, "#[Histogram log format version %s]\n", logFormatVersion);
    }

    public void outputStartTime(long startTime) {
        this.writer.format(Locale.US, "#[StartTime: %.3f (seconds since epoch), %s]\n", (double)startTime / 1000.0, new Date(startTime));
        this.writer.flush();
    }

    public void outputTimeUnit(TimeUnit timeUnit) {
        this.writer.format(Locale.US, "#[TimeUnit: %s]\n", timeUnit.toString());
        this.writer.flush();
    }

    public void outputLegend() {
        this.writer.format(Locale.US, "#Tag,Interval_Start,Interval_Length,count,min,p25,p50,p75,p90,p95,p98,p99,p999,p9999,max\n", new Object[0]);
    }

    public void writeInterval(Histogram h) {
        StringBuilder csvLine = new StringBuilder(1024);
        csvLine.append("Tag=").append(h.getTag()).append(",");
        Double start = ((double)h.getStartTimeStamp() - (double)this.baseTime) / 1000.0;
        Double end = ((double)h.getEndTimeStamp() - (double)this.baseTime) / 1000.0;
        String len = String.format(Locale.US, "%.3f", end - start);
        csvLine.append(start);
        csvLine.append(",").append(len);
        csvLine.append(",").append(h.getTotalCount());
        csvLine.append(",").append(h.getMinValue());
        csvLine.append(",").append(h.getValueAtPercentile(25.0));
        csvLine.append(",").append(h.getValueAtPercentile(50.0));
        csvLine.append(",").append(h.getValueAtPercentile(75.0));
        csvLine.append(",").append(h.getValueAtPercentile(90.0));
        csvLine.append(",").append(h.getValueAtPercentile(95.0));
        csvLine.append(",").append(h.getValueAtPercentile(98.0));
        csvLine.append(",").append(h.getValueAtPercentile(99.0));
        csvLine.append(",").append(h.getValueAtPercentile(99.9));
        csvLine.append(",").append(h.getValueAtPercentile(99.99));
        csvLine.append(",").append(h.getMaxValue());
        this.writer.println(csvLine);
    }
}

