/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.metrics.ConvenientSnapshot;
import io.nosqlbench.engine.api.metrics.DeltaHdrHistogramReservoir;
import io.nosqlbench.engine.api.metrics.DeltaSnapshotReader;
import io.nosqlbench.engine.api.metrics.DeltaSnapshotter;
import io.nosqlbench.engine.api.metrics.HdrDeltaHistogramAttachment;
import io.nosqlbench.engine.api.metrics.TimerAttachment;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;

public class NicerTimer
extends Timer
implements DeltaSnapshotter,
HdrDeltaHistogramAttachment,
TimerAttachment {
    private final String metricName;
    private final DeltaHdrHistogramReservoir deltaHdrHistogramReservoir;
    private long cacheExpiry = 0L;
    private List<Timer> mirrors;

    public NicerTimer(String metricName, DeltaHdrHistogramReservoir deltaHdrHistogramReservoir) {
        super((Reservoir)deltaHdrHistogramReservoir);
        this.metricName = metricName;
        this.deltaHdrHistogramReservoir = deltaHdrHistogramReservoir;
    }

    public ConvenientSnapshot getSnapshot() {
        if (System.currentTimeMillis() >= this.cacheExpiry) {
            return new ConvenientSnapshot(this.deltaHdrHistogramReservoir.getSnapshot());
        }
        return new ConvenientSnapshot(this.deltaHdrHistogramReservoir.getLastSnapshot());
    }

    @Override
    public DeltaSnapshotReader getDeltaReader() {
        return new DeltaSnapshotReader(this);
    }

    @Override
    public ConvenientSnapshot getDeltaSnapshot(long cacheTimeMillis) {
        this.cacheExpiry = System.currentTimeMillis() + cacheTimeMillis;
        return new ConvenientSnapshot(this.deltaHdrHistogramReservoir.getSnapshot());
    }

    @Override
    public synchronized NicerTimer attachHdrDeltaHistogram() {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<Timer>();
        }
        DeltaHdrHistogramReservoir sameConfigReservoir = this.deltaHdrHistogramReservoir.copySettings();
        NicerTimer mirror = new NicerTimer(this.metricName, sameConfigReservoir);
        this.mirrors.add(mirror);
        return mirror;
    }

    @Override
    public Timer attachTimer(Timer timer) {
        if (this.mirrors == null) {
            this.mirrors = new CopyOnWriteArrayList<Timer>();
        }
        this.mirrors.add(timer);
        return timer;
    }

    @Override
    public Histogram getNextHdrDeltaHistogram() {
        return this.deltaHdrHistogramReservoir.getNextHdrHistogram();
    }

    public void update(long duration, TimeUnit unit) {
        super.update(duration, unit);
        if (this.mirrors != null) {
            for (Timer mirror : this.mirrors) {
                mirror.update(duration, unit);
            }
        }
    }
}

