/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PeriodicRunnable<T extends Runnable>
implements Runnable,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(PeriodicRunnable.class);
    private final long intervalMillis;
    private final T action;
    private Thread thread;
    private volatile boolean running = false;

    public PeriodicRunnable(long intervalMillis, T action) {
        this.action = action;
        this.intervalMillis = intervalMillis;
    }

    public synchronized PeriodicRunnable<T> startDaemonThread() {
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.setName(this.action.toString());
        this.thread.start();
        return this;
    }

    @Override
    public synchronized void close() {
        this.running = false;
        try {
            this.thread.join(0L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized PeriodicRunnable<T> startMainThread() {
        this.thread = new Thread(this);
        this.thread.setName(this.action.toString());
        this.thread.start();
        return this;
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void run() {
        this.running = true;
        long nextEventTime = System.currentTimeMillis() + this.intervalMillis;
        while (this.running) {
            nextEventTime = this.awaitTime(this.intervalMillis, nextEventTime);
            logger.trace("invoking interval runnable " + this.action);
            this.action.run();
        }
    }

    private long awaitTime(long interval, long nextEventTime) {
        long duration = nextEventTime - System.currentTimeMillis();
        while (System.currentTimeMillis() < nextEventTime) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {}
        }
        return nextEventTime + interval;
    }
}

