/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.util;

import io.nosqlbench.nb.api.config.standard.ConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.config.standard.NBMapConfigurable;
import io.nosqlbench.nb.api.config.standard.Param;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSLKsFactory
implements NBMapConfigurable {
    private static final Logger logger = LogManager.getLogger(SSLKsFactory.class);
    private static final SSLKsFactory instance = new SSLKsFactory();
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);
    private static final Pattern KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    public static final String SSL = "ssl";
    public static final String DEFAULT_TLSVERSION = "TLSv1.2";

    private SSLKsFactory() {
    }

    public static SSLKsFactory get() {
        return instance;
    }

    public ServerSocketFactory createSSLServerSocketFactory(NBConfiguration cfg) {
        SSLContext context = this.getContext(cfg);
        if (context == null) {
            throw new IllegalArgumentException("SSL is not enabled.");
        }
        return context.getServerSocketFactory();
    }

    public SocketFactory createSocketFactory(NBConfiguration cfg) {
        SSLContext context = this.getContext(cfg);
        if (context == null) {
            throw new IllegalArgumentException("SSL is not enabled.");
        }
        return context.getSocketFactory();
    }

    public SSLContext getContext(NBConfiguration cfg) {
        Optional<String> sslParam = cfg.getOptional(SSL);
        if (sslParam.isPresent()) {
            TrustManagerFactory tmf;
            KeyManagerFactory kmf;
            KeyStore trustStore;
            KeyStore keyStore;
            String tlsVersion = cfg.getOptional("tlsversion").orElse(DEFAULT_TLSVERSION);
            char[] keyPassword = null;
            if (sslParam.get().equals("jdk")) {
                char[] keyStorePassword = cfg.getOptional("kspass").map(String::toCharArray).orElse(null);
                keyPassword = cfg.getOptional("keyPassword", "keypassword").map(String::toCharArray).orElse(keyStorePassword);
                keyStore = cfg.getOptional("keystore").map(ksPath -> {
                    try {
                        return KeyStore.getInstance(new File((String)ksPath), keyStorePassword);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load the keystore. Please check.", e);
                    }
                }).orElse(null);
                trustStore = cfg.getOptional("truststore").map(tsPath -> {
                    try {
                        return KeyStore.getInstance(new File((String)tsPath), cfg.getOptional("tspass").map(String::toCharArray).orElse(null));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to load the truststore. Please check.", e);
                    }
                }).orElse(null);
            } else {
                if (sslParam.get().equals("openssl")) {
                    try {
                        File keyFile;
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        keyStore = KeyStore.getInstance("JKS");
                        keyStore.load(null, null);
                        Certificate cert = cfg.getOptional("certFilePath").map(certFilePath -> {
                            Certificate certificate;
                            ByteArrayInputStream is = new ByteArrayInputStream(SSLKsFactory.loadCertFromPem(new File((String)certFilePath)));
                            try {
                                certificate = cf.generateCertificate(is);
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(String.format("Unable to load cert from %s. Please check.", certFilePath), e);
                                }
                            }
                            ((InputStream)is).close();
                            return certificate;
                        }).orElse(null);
                        if (cert != null) {
                            keyStore.setCertificateEntry("certFile", cert);
                        }
                        if ((keyFile = (File)cfg.getOptional("keyfilepath").map(File::new).orElse(null)) != null) {
                            try {
                                Certificate[] certificateArray;
                                keyPassword = cfg.getOptional("keyPassword", "keypassword").map(String::toCharArray).orElse("temp_key_password".toCharArray());
                                KeyFactory kf = KeyFactory.getInstance("RSA");
                                PrivateKey key = kf.generatePrivate(new PKCS8EncodedKeySpec(SSLKsFactory.loadKeyFromPem(keyFile)));
                                if (cert != null) {
                                    Certificate[] certificateArray2 = new Certificate[1];
                                    certificateArray = certificateArray2;
                                    certificateArray2[0] = cert;
                                } else {
                                    certificateArray = null;
                                }
                                keyStore.setKeyEntry("key", key, keyPassword, certificateArray);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(String.format("Unable to load key from %s. Please check.", keyFile), e);
                            }
                        }
                        trustStore = cfg.getOptional("caCertFilePath", "cacertfilepath").map(caCertFilePath -> {
                            KeyStore keyStore;
                            FileInputStream is = new FileInputStream(new File((String)caCertFilePath));
                            try {
                                KeyStore ts = KeyStore.getInstance("JKS");
                                ts.load(null, null);
                                Certificate caCert = cf.generateCertificate(is);
                                ts.setCertificateEntry("caCertFile", caCert);
                                keyStore = ts;
                            }
                            catch (Throwable throwable) {
                                try {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(String.format("Unable to load caCert from %s. Please check.", caCertFilePath), e);
                                }
                            }
                            ((InputStream)is).close();
                            return keyStore;
                        }).orElse(null);
                    }
                    catch (RuntimeException re) {
                        throw re;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException("The 'ssl' parameter must have one of jdk, or openssl");
            }
            try {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(keyStore, keyPassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to init KeyManagerFactory. Please check password and location.", e);
            }
            try {
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(trustStore != null ? trustStore : keyStore);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to init TrustManagerFactory. Please check.", e);
            }
            try {
                SSLContext sslContext = SSLContext.getInstance(tlsVersion);
                sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
                return sslContext;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static byte[] loadPem(Pattern pattern, File pemFile) throws IOException {
        try (FileInputStream in = new FileInputStream(pemFile);){
            String pem = new String(((InputStream)in).readAllBytes(), StandardCharsets.ISO_8859_1);
            String encoded = pattern.matcher(pem).replaceFirst("$1");
            byte[] byArray = Base64.getMimeDecoder().decode(encoded);
            return byArray;
        }
    }

    private static byte[] loadKeyFromPem(File keyPemFile) throws IOException {
        return SSLKsFactory.loadPem(KEY_PATTERN, keyPemFile);
    }

    private static byte[] loadCertFromPem(File certPemFile) throws IOException {
        return SSLKsFactory.loadPem(CERT_PATTERN, certPemFile);
    }

    @Override
    public void applyConfig(Map<String, ?> providedConfig) {
    }

    @Override
    public NBConfigModel getConfigModel() {
        return ConfigModel.of(SSLKsFactory.class, Param.optional(SSL).setDescription("Enable ssl and set the mode").setRegex("jdk|openssl"), Param.defaultTo("tlsversion", DEFAULT_TLSVERSION), Param.optional("kspass"), Param.optional("keyPassword"), Param.optional("keystore"), Param.optional("truststore"), Param.optional("tspass"), Param.optional(List.of("keyFilePath", "keyfilepath")), Param.optional("caCertFilePath"), Param.optional("certFilePath")).asReadOnly();
    }
}

