/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.nb.api.metadata.SessionNamer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class NBEnvironment {
    private Logger logger;
    public static final String NBSTATEDIR = "NBSTATEDIR";
    public static final String NBLIBS = "NBLIBDIR";
    public static final NBEnvironment INSTANCE = new NBEnvironment();
    private final LinkedHashMap<String, String> references = new LinkedHashMap();
    private static final Map<String, String> envToProp = Map.of("PWD", "user.dir", "HOME", "user.home", "USERNAME", "user.name", "USER", "user.name", "LOGNAME", "user.name");

    NBEnvironment() {
    }

    public NBEnvironment resetRefs() {
        this.references.clear();
        return this;
    }

    public void put(String propname, String value) {
        if (envToProp.containsKey(propname)) {
            throw new RuntimeException("The property you are changing should be considered immutable in this process: '" + propname + "'");
        }
        if (this.references.containsKey(propname)) {
            if (this.references.get(propname).equals(value)) {
                if (this.logger != null) {
                    this.logger.warn("changing already referenced property '" + propname + "' to same value");
                }
            } else {
                throw new BasicError("Changing already referenced property '" + propname + "' from \n'" + this.references.get(propname) + "' to '" + value + "' is not supported.\n (maybe you can change the order of your options to set higher-level parameters first.)");
            }
        }
        System.setProperty(propname, value);
    }

    private String reference(String name, String value) {
        this.references.put(name, value);
        return value;
    }

    public String getOr(String name, String defaultValue, Map<String, String> supplemental) {
        String value = this.peek(name, supplemental);
        if (value == null) {
            value = defaultValue;
        }
        return this.reference(name, value);
    }

    public String getOr(String name, String defaultValue) {
        return this.getOr(name, defaultValue, Map.of());
    }

    private String peek(String name, Map<String, String> supplemental) {
        String value = null;
        if (supplemental.containsKey(name) && (value = supplemental.get(name)) != null) {
            return value;
        }
        if (name.contains(".") && (value = System.getProperty(name.toLowerCase())) != null) {
            return value;
        }
        if (envToProp.containsKey(name.toUpperCase())) {
            String propName = envToProp.get(name.toUpperCase());
            if (this.logger != null) {
                this.logger.debug("redirecting env var '" + name + "' to upper-case property '" + propName + "'");
            }
            if ((value = System.getProperty(propName)) != null) {
                return value;
            }
        }
        if ((value = System.getProperty(name)) != null) {
            return value;
        }
        value = System.getenv(name);
        return value;
    }

    public String get(String name) {
        String value = this.getOr(name, null);
        if (value == null) {
            throw new BasicError("No variable was found for '" + name + "' in system properties nor in the shell environment.");
        }
        return value;
    }

    public boolean containsKey(String name) {
        return this.containsKey(name, Map.of());
    }

    public boolean containsKey(String name, Map<String, String> supplemental) {
        String value = this.peek(name, supplemental);
        return value != null;
    }

    public Optional<String> interpolate(String word, Map<String, String> supplemental) {
        Pattern envpattern = Pattern.compile("(\\$(?<env1>[a-zA-Z_][A-Za-z0-9_.]+)|\\$\\{(?<env2>[^}]+)\\})");
        Matcher matcher = envpattern.matcher(word);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String value;
            String envvar = matcher.group("env1");
            if (envvar == null) {
                envvar = matcher.group("env2");
            }
            if ((value = this.peek(envvar, supplemental)) == null) {
                if (this.logger != null) {
                    this.logger.debug("no value found for '" + envvar + "', returning Optional.empty() for '" + word + "'");
                }
                return Optional.empty();
            }
            value = this.reference(envvar, value);
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return Optional.of(sb.toString());
    }

    public Optional<String> interpolate(String word) {
        return this.interpolate(word, Map.of());
    }

    public List<String> interpolateEach(CharSequence delim, String toBeRecombined) {
        String[] split = toBeRecombined.split(delim.toString());
        ArrayList<String> mapped = new ArrayList<String>();
        for (String pattern : split) {
            Optional<String> interpolated = this.interpolate(pattern);
            interpolated.ifPresent(mapped::add);
        }
        return mapped;
    }

    public final Optional<String> interpolateWithTimestamp(String rawtext, long millis, Map<String, String> map) {
        String result = rawtext;
        result = SessionNamer.format(result, millis);
        return this.interpolate(result, map);
    }

    public final Optional<String> interpolateWithTimestamp(String rawText, long millis) {
        return this.interpolateWithTimestamp(rawText, millis, Map.of());
    }
}

