/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.annotations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import io.nosqlbench.nb.api.annotations.Annotation;
import io.nosqlbench.nb.api.annotations.Layer;
import io.nosqlbench.nb.api.annotations.Span;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;

public class MutableAnnotation
implements Annotation {
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    private String session = "SESSION_UNNAMED";
    private final ZoneId GMT = ZoneId.of("GMT");
    @Expose
    private Layer layer;
    @Expose
    private long start = 0L;
    @Expose
    private long end = 0L;
    @Expose
    private Map<String, String> labels = new LinkedHashMap<String, String>();
    @Expose
    private Map<String, String> details = new LinkedHashMap<String, String>();
    private final ZoneId zoneid = ZoneId.of("GMT");

    public MutableAnnotation(TimeZone timezone, String session, Layer layer, long start, long end, LinkedHashMap<String, String> labels, LinkedHashMap<String, String> details) {
        this.setLabels(labels);
        this.setSession(session);
        this.setLayer(layer);
        this.setStart(start);
        this.setEnd(end);
        this.setDetails(details);
        labels.put("appname", "nosqlbench");
    }

    public void setSession(String sessionName) {
        this.session = sessionName;
        this.labels.put("session", sessionName);
    }

    public void setStart(long intervalStart) {
        this.start = intervalStart;
        this.labels.put("span", this.getSpan().toString());
    }

    public void setEnd(long intervalEnd) {
        this.end = intervalEnd;
        this.labels.put("span", this.getSpan().toString());
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        this.labels.put("layer", layer.toString());
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    @Override
    public String getSession() {
        return this.session;
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public Map<String, String> getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("session: ").append(this.getSession()).append("\n");
        ZonedDateTime startTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getStart()), this.zoneid);
        ZonedDateTime endTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getStart()), this.zoneid);
        sb.append("[");
        ZonedDateTime zonedStartTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getStart()), this.zoneid);
        sb.append(zonedStartTime.format(DateTimeFormatter.ISO_INSTANT));
        if (this.getStart() != this.getEnd()) {
            ZonedDateTime zonedEndTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getEnd()), this.zoneid);
            sb.append(" - ").append(zonedEndTime.format(DateTimeFormatter.ISO_INSTANT));
        }
        sb.append("]\n");
        sb.append("span:").append((Object)this.getSpan()).append("\n");
        sb.append("details:\n");
        this.formatMap(sb, this.getDetails());
        sb.append("labels:\n");
        this.formatMap(sb, this.getLabels());
        return sb.toString();
    }

    private void formatMap(StringBuilder sb, Map<String, String> details) {
        details.forEach((k, v) -> {
            sb.append(" ").append((String)k).append(": ");
            if (v.contains("\n")) {
                String[] lines;
                sb.append("\n");
                for (String line : lines = v.split("\n+")) {
                    sb.append("  " + line + "\n");
                }
            } else {
                sb.append((String)v).append("\n");
            }
        });
    }

    public Annotation asReadOnly() {
        return this;
    }

    @Override
    public Span getSpan() {
        return this.getStart() == this.getEnd() ? Span.instant : Span.interval;
    }

    @Override
    public String asJson() {
        String inlineForm = gson.toJson((Object)this);
        return inlineForm;
    }
}

