/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.params;

import io.nosqlbench.nb.api.config.params.Element;
import io.nosqlbench.nb.api.config.params.ElementData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ElementImpl
implements Element {
    private final ElementData data;

    public ElementImpl(ElementData data) {
        this.data = data;
    }

    @Override
    public String getElementName() {
        String name = this.data.getGivenName();
        if (name != null) {
            return name;
        }
        return this.get("name", String.class).orElse(null);
    }

    @Override
    public <T> Optional<T> get(String name, Class<? extends T> classOfT) {
        T found = this.lookup(this.data, name, classOfT);
        return Optional.ofNullable(found);
    }

    @Override
    public <T> Optional<T> get(String name) {
        return Optional.ofNullable(this.data.lookup(name, null));
    }

    private <T> T lookup(ElementData data, String name, Class<T> type) {
        return data.lookup(name, type);
    }

    @Override
    public <T> T getOr(String name, T defaultValue) {
        Class<?> cls = defaultValue.getClass();
        return (T)this.get(name, cls).orElse(defaultValue);
    }

    @Override
    public Map<String, Object> getMap() {
        Set<String> keys = this.data.getKeys();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            Object value = this.data.get(key);
            map.put(key, value);
        }
        return map;
    }

    public String toString() {
        return this.data.toString();
    }
}

