/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.params;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.nosqlbench.nb.api.config.params.ElementData;
import java.util.Set;

public class JsonBackedConfigElement
implements ElementData {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final JsonObject jsonObject;
    private final String name;

    public JsonBackedConfigElement(String injectedName, JsonObject jsonObject) {
        this.name = injectedName;
        this.jsonObject = jsonObject;
    }

    @Override
    public Object get(String name) {
        return this.jsonObject.get(name);
    }

    @Override
    public Set<String> getKeys() {
        return this.jsonObject.keySet();
    }

    @Override
    public boolean containsKey(String name) {
        return this.jsonObject.keySet().contains(name);
    }

    @Override
    public String getGivenName() {
        return this.name;
    }

    @Override
    public <T> T convert(Object input, Class<T> type) {
        if (input instanceof JsonElement) {
            Object result = gson.fromJson((JsonElement)input, type);
            return (T)result;
        }
        throw new RuntimeException("Unable to convert json element from '" + input.getClass().getSimpleName() + "' to '" + type.getSimpleName() + "'");
    }

    public String toString() {
        return this.getGivenName() + "(" + (this.extractElementName() != null ? this.extractElementName() : "null") + "):" + this.jsonObject.toString();
    }

    @Override
    public String extractElementName() {
        if (this.jsonObject.has("name")) {
            return this.jsonObject.get("name").getAsString();
        }
        return null;
    }
}

