/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.params;

import io.nosqlbench.nb.api.config.params.Synonyms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParamsParser {
    public static final String ASSIGN_CHARS = "=:";
    private static final Logger logger = LogManager.getLogger(ParamsParser.class);

    public static Map<String, String> parse(String input, boolean canonicalize) {
        return ParamsParser.parse(input, ASSIGN_CHARS, canonicalize);
    }

    public static boolean hasValues(String input) {
        return ParamsParser.hasValues(input, ASSIGN_CHARS);
    }

    public static boolean hasValues(String input, String assignChars) {
        for (int i = 0; i < assignChars.length(); ++i) {
            Pattern assignPattern = Pattern.compile("[A-Za-z_][-_\\w\\d.]*\\s*" + assignChars.charAt(i) + ".*");
            if (!assignPattern.matcher(input).matches()) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> parse(String input, String assignmentCharacters, boolean canonicalize) {
        ParseState s = ParseState.expectingName;
        LinkedHashMap<String, String> parms = new LinkedHashMap<String, String>();
        StringBuilder varname = new StringBuilder(512);
        StringBuilder value = new StringBuilder(512);
        String lastVarname = null;
        boolean isEscaped = false;
        block17: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (isEscaped) {
                switch (s) {
                    case expectingVal: 
                    case readingDquotedVal: 
                    case readingSquotedVal: 
                    case readingRawVal: {
                        value.append(c);
                        break;
                    }
                    case readingName: {
                        varname.append(c);
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid position for escape:" + i + ", in " + input);
                    }
                }
                isEscaped = false;
                continue;
            }
            switch (s) {
                case expectingName: {
                    if (c == '\'' || c == '\"') {
                        throw new RuntimeException("Unable to parse a name starting with character '" + c + "'. Names must be literal values.");
                    }
                    if (c == ' ' || c == ';') continue block17;
                    s = ParseState.readingName;
                    varname.append(c);
                    continue block17;
                }
                case readingName: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block17;
                    }
                    if (c == ' ') {
                        String partial = (String)parms.get(lastVarname);
                        if (partial == null) {
                            throw new RuntimeException("space continuation while reading name or value, but no prior for " + lastVarname + " exists");
                        }
                        parms.put(lastVarname, partial + " " + varname);
                        varname.setLength(0);
                        continue block17;
                    }
                    if (assignmentCharacters.indexOf(c) == -1) {
                        varname.append(c);
                        continue block17;
                    }
                    s = ParseState.expectingVal;
                    continue block17;
                }
                case expectingVal: {
                    if (c == ' ') continue block17;
                    if (c == '\\') {
                        isEscaped = true;
                        continue block17;
                    }
                    if (c == '\'') {
                        s = ParseState.readingSquotedVal;
                        continue block17;
                    }
                    if (c == '\"') {
                        s = ParseState.readingDquotedVal;
                        continue block17;
                    }
                    if (c == ';') {
                        parms.put(varname.toString(), null);
                        varname.setLength(0);
                        s = ParseState.expectingName;
                        continue block17;
                    }
                    s = ParseState.readingRawVal;
                    value.append(c);
                    continue block17;
                }
                case readingRawVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block17;
                    }
                    if (c != ';' && c != ' ') {
                        value.append(c);
                        continue block17;
                    }
                    parms.put(varname.toString(), value.toString());
                    lastVarname = varname.toString();
                    varname.setLength(0);
                    value.setLength(0);
                    s = ParseState.expectingName;
                    continue block17;
                }
                case readingSquotedVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block17;
                    }
                    if (c != '\'') {
                        value.append(c);
                        continue block17;
                    }
                    parms.put(varname.toString(), value.toString());
                    varname.setLength(0);
                    value.setLength(0);
                    s = ParseState.expectingName;
                    continue block17;
                }
                case readingDquotedVal: {
                    if (c == '\\') {
                        isEscaped = true;
                        continue block17;
                    }
                    if (c != '\"') {
                        value.append(c);
                        continue block17;
                    }
                    parms.put(varname.toString(), value.toString());
                    varname.setLength(0);
                    value.setLength(0);
                    s = ParseState.expectingName;
                    continue block17;
                }
                default: {
                    throw new RuntimeException("Unmatched parse state. This should be impossible.");
                }
            }
        }
        if (isEscaped) {
            throw new RuntimeException("an unfinished escape sequence at the end is not valid");
        }
        switch (s) {
            case expectingVal: {
                parms.put(varname.toString(), null);
                varname.setLength(0);
                s = ParseState.expectingName;
                break;
            }
            case readingRawVal: {
                parms.put(varname.toString(), value.toString());
                varname.setLength(0);
                s = ParseState.expectingName;
                break;
            }
            case readingName: {
                parms.put(lastVarname, (String)parms.get(lastVarname) + " " + varname);
                varname.setLength(0);
                break;
            }
        }
        if (input.length() > 0 && parms.size() == 0) {
            throw new RuntimeException("Unable to parse input:" + input);
        }
        if (canonicalize) {
            ArrayList keys = new ArrayList(parms.keySet());
            for (String key : keys) {
                String properkey;
                if (key.equals(properkey = Synonyms.canonicalize(key, logger))) continue;
                parms.put(properkey, (String)parms.get(key));
                parms.remove(key);
            }
        }
        return parms;
    }

    public static Map<String, String> parseToMap(Object src, String mainField) {
        if (src instanceof Map) {
            return (Map)src;
        }
        if (src instanceof CharSequence) {
            String input = ((CharSequence)src).toString();
            if (ParamsParser.hasValues(input)) {
                return ParamsParser.parse(input, false);
            }
            return new HashMap<String, String>(Map.of(mainField, input));
        }
        throw new RuntimeException("can't parseToMap(...) on an object that is neither Map nor CharSequence");
    }

    private static enum ParseState {
        expectingName,
        readingName,
        expectingVal,
        readingRawVal,
        readingSquotedVal,
        readingDquotedVal;

    }
}

