/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.standard;

import io.nosqlbench.nb.api.errors.BasicError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConfigData {
    private final ConfigData inner;
    private final LinkedHashMap<String, Object> configs;

    public ConfigData(LinkedHashMap<String, Object> configs, ConfigData inner) {
        this.configs = configs;
        this.inner = inner;
    }

    public ConfigData(LinkedHashMap<String, Object> configs) {
        this.configs = configs;
        this.inner = null;
    }

    public ConfigData() {
        this.configs = new LinkedHashMap();
        this.inner = null;
    }

    public ConfigData layer() {
        return new ConfigData(new LinkedHashMap<String, Object>(), this);
    }

    public ConfigData layer(Map<String, Object> configs) {
        return new ConfigData(new LinkedHashMap<String, Object>(configs), this);
    }

    public <T> Optional<T> get(String name, Class<? extends T> type) {
        Object o = this.configs.get(name);
        if (o != null) {
            if (type.isAssignableFrom(o.getClass())) {
                return Optional.of(type.cast(o));
            }
            throw new BasicError("Tried to access a virtdata config element named '" + name + "' as a '" + type.getCanonicalName() + "', but it was not compatible with that type");
        }
        if (this.inner != null) {
            return this.inner.get(name, type);
        }
        return Optional.empty();
    }

    public <T> Optional<List<T>> getList(String name, Class<? extends T> type) {
        Optional<List> found = this.get(name, List.class);
        if (found.isPresent()) {
            ArrayList<T> list = new ArrayList<T>();
            for (Object o : found.get()) {
                if (type.isAssignableFrom(o.getClass())) {
                    list.add(type.cast(o));
                    continue;
                }
                throw new BasicError("Tried to access a virtdata config list element found under name '" + name + "' as a '" + type.getCanonicalName() + "', but it was not compatible with that type");
            }
            return Optional.of(list);
        }
        return Optional.empty();
    }

    public void put(String paramName, List<String> paramValue) {
        this.configs.put(paramName, paramValue);
    }
}

