/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.standard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.nosqlbench.nb.api.config.params.ParamsParser;
import io.nosqlbench.nb.api.content.NBIO;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigLoader {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger logger = LogManager.getLogger((String)"CONFIG");

    public <V> LinkedHashMap<String, V> loadMap(CharSequence source, Class<? extends V> type, Function<V, String> keyer) {
        LinkedHashMap<String, V> mapOf = new LinkedHashMap<String, V>();
        List<V> elems = this.load(source, type);
        for (V elem : elems) {
            String key = keyer.apply(elem);
            if (mapOf.containsKey(key)) {
                throw new RuntimeException("Duplicitous key mappings are disallowed here.");
            }
            mapOf.put(key, elem);
        }
        return mapOf;
    }

    public <T> List<T> load(CharSequence source, Class<? extends T> type) {
        ArrayList<Object> cfgs = new ArrayList<Object>();
        String data = source.toString();
        if ((data = data.trim()).isEmpty()) {
            return null;
        }
        if (data.startsWith("IMPORT{") && data.endsWith("}")) {
            String filename = data.substring("IMPORT{".length(), data.length() - 1);
            Path filepath = Path.of(filename, new String[0]);
            data = NBIO.all().name(filename).first().map(c -> {
                logger.debug("found 'data' at " + c.getURI());
                return c.asString();
            }).orElseThrow();
        }
        if (data.startsWith("{") || data.startsWith("[")) {
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(data);
            if (jsonElement.isJsonArray()) {
                JsonArray asJsonArray = jsonElement.getAsJsonArray();
                for (JsonElement element : asJsonArray) {
                    Object object = gson.fromJson(element, type);
                    cfgs.add(object);
                }
            } else if (jsonElement.isJsonObject()) {
                cfgs.add(gson.fromJson(jsonElement, type));
            }
        } else if (Map.class.isAssignableFrom(type)) {
            Map<String, String> parsedMap = ParamsParser.parse(data, false);
            cfgs.add(type.cast(parsedMap));
        }
        return cfgs;
    }
}

