/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.standard;

import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.nb.api.config.standard.ConfigSuggestions;
import io.nosqlbench.nb.api.config.standard.NBConfigError;
import io.nosqlbench.nb.api.config.standard.NBConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.config.standard.Param;
import io.nosqlbench.nb.api.errors.BasicError;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ConfigModel
implements NBConfigModel {
    private final Map<String, Param<?>> paramsByName = new LinkedHashMap();
    private final List<Param<?>> params = new ArrayList();
    private Param<?> lastAdded = null;
    private final Class<?> ofType;

    private ConfigModel(Class<?> ofType, Param<?> ... params) {
        this.ofType = ofType;
        for (Param<?> param : params) {
            this.add(param);
        }
    }

    public static ConfigModel of(Class<?> ofType, Param<?> ... params) {
        return new ConfigModel(ofType, params);
    }

    public static ConfigModel of(Class<?> ofType) {
        return new ConfigModel(ofType, new Param[0]);
    }

    public static NBConfiguration defacto(ActivityDef def) {
        ConfigModel configModel = new ConfigModel(Object.class, new Param[0]);
        for (Map.Entry<String, Object> entry : def.getParams().entrySet()) {
            configModel.add(Param.defaultTo(entry.getKey(), entry.getValue().toString()));
        }
        return configModel.apply(def.getParams());
    }

    public <T> ConfigModel add(Param<T> param) {
        this.params.add(param);
        for (String name : param.getNames()) {
            this.paramsByName.put(name, param);
        }
        this.lastAdded = null;
        return this;
    }

    public NBConfigModel asReadOnly() {
        return this;
    }

    @Override
    public Map<String, Param<?>> getNamedParams() {
        return Collections.unmodifiableMap(this.paramsByName);
    }

    @Override
    public List<Param<?>> getParams() {
        return new ArrayList(this.params);
    }

    @Override
    public Class<?> getOf() {
        return this.ofType;
    }

    public static <T> T convertValueTo(String configName, String paramName, Object value, Class<T> type) {
        if (type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            Number number = (Number)value;
            if (type.equals(Float.class) || type == Float.TYPE) {
                return (T)Float.valueOf(number.floatValue());
            }
            if (type.equals(Integer.class) || type == Integer.TYPE) {
                return (T)Integer.valueOf(number.intValue());
            }
            if (type.equals(Double.class) || type == Double.TYPE) {
                return (T)Double.valueOf(number.doubleValue());
            }
            if (type.equals(Long.class) || type == Long.TYPE) {
                return (T)Long.valueOf(number.longValue());
            }
            if (type.equals(Byte.class) || type == Byte.TYPE) {
                return (T)Byte.valueOf(number.byteValue());
            }
            if (type.equals(Short.class) || type == Short.TYPE) {
                return (T)Short.valueOf(number.shortValue());
            }
            throw new RuntimeException("Number type " + type.getSimpleName() + " could  not be converted from " + value.getClass().getSimpleName());
        }
        if (value instanceof CharSequence) {
            String string = ((CharSequence)value).toString();
            if (type == Integer.TYPE || type == Integer.class) {
                return (T)Integer.valueOf(string);
            }
            if (type == Character.TYPE || type == Character.class && string.length() == 1) {
                return (T)Character.valueOf(string.charAt(0));
            }
            if (type == Long.TYPE || type == Long.class) {
                return (T)Long.valueOf(string);
            }
            if (type == Float.TYPE || type == Float.class) {
                return (T)Float.valueOf(string);
            }
            if (type == Double.TYPE || type == Double.class) {
                return (T)Double.valueOf(string);
            }
            if (type == BigDecimal.class) {
                return (T)BigDecimal.valueOf(Double.parseDouble(string));
            }
            throw new RuntimeException("CharSequence type " + type.getSimpleName() + " could  not be converted from " + value.getClass().getSimpleName());
        }
        throw new RuntimeException("While configuring " + paramName + " for " + configName + ", Unable to convert " + value.getClass() + " to " + type.getCanonicalName());
    }

    @Override
    public NBConfiguration extractConfig(Map<String, ?> sharedConfig) {
        LinkedHashMap<String, Object> extracted = new LinkedHashMap<String, Object>();
        for (String providedCfgField : sharedConfig.keySet()) {
            if (!this.getNamedParams().containsKey(providedCfgField)) continue;
            extracted.put(providedCfgField, sharedConfig.get(providedCfgField));
        }
        extracted.keySet().forEach(sharedConfig::remove);
        return new NBConfiguration(this, extracted);
    }

    @Override
    public NBConfiguration extractConfig(NBConfiguration cfg) {
        return this.extractConfig(cfg.getMap());
    }

    private void assertDistinctSynonyms(Map<String, ?> config) {
        ArrayList<String> names = new ArrayList<String>();
        for (Param<?> param : this.getParams()) {
            names.clear();
            for (String s : param.getNames()) {
                if (!config.containsKey(s)) continue;
                names.add(s);
            }
            if (names.size() <= 1) continue;
            throw new NBConfigError("Multiple names for the same parameter were provided: " + names);
        }
    }

    @Override
    public NBConfiguration apply(Map<String, ?> config) {
        this.assertValidConfig(config);
        LinkedHashMap<String, Object> validConfig = new LinkedHashMap<String, Object>();
        for (Param<?> param : this.params) {
            Class<?> type = param.getType();
            ArrayList found = new ArrayList();
            String activename = null;
            Object cval = null;
            for (String name : param.getNames()) {
                if (!config.containsKey(name)) continue;
                cval = config.get(name);
                activename = name;
                break;
            }
            if (activename == null) {
                activename = param.getNames().get(0);
            }
            if (cval == null && param.isRequired()) {
                activename = param.getNames().get(0);
                cval = param.getDefaultValue();
            }
            if (cval == null) continue;
            cval = ConfigModel.convertValueTo(this.ofType.getSimpleName(), activename, cval, type);
            validConfig.put(activename, cval);
        }
        return new NBConfiguration(this.asReadOnly(), validConfig);
    }

    @Override
    public void assertValidConfig(Map<String, ?> config) {
        this.assertRequiredFields(config);
        this.assertNoExtraneousFields(config);
        this.assertDistinctSynonyms(config);
    }

    public Param<?> getParam(String ... names) {
        for (String name : names) {
            if (!this.getNamedParams().containsKey(name)) continue;
            return this.getNamedParams().get(name);
        }
        return null;
    }

    public ConfigModel validIfRegex(String s) {
        Pattern regex = Pattern.compile(s);
        this.lastAdded.setRegex(regex);
        return this;
    }

    private void assertRequiredFields(Map<String, ?> config) {
        for (Param<?> param : this.params) {
            if (!param.isRequired() || param.getDefaultValue() != null) continue;
            boolean provided = false;
            for (String name : param.getNames()) {
                if (!config.containsKey(name)) continue;
                provided = true;
                break;
            }
            if (provided) continue;
            throw new RuntimeException("A required config element named '" + param.getNames() + "' and type '" + param.getType().getSimpleName() + "' was not found\nfor configuring a " + this.getOf().getSimpleName());
        }
    }

    private void assertNoExtraneousFields(Map<String, ?> config) {
        for (String configkey : config.keySet()) {
            Param<?> element = this.paramsByName.get(configkey);
            if (element == null) {
                StringBuilder paramhelp = new StringBuilder("Unknown config parameter '" + configkey + "' in config model while configuring " + this.getOf().getSimpleName() + ", possible parameter names are " + this.paramsByName.keySet() + ".");
                ConfigSuggestions.getForParam(this, configkey).ifPresent(suggestion -> paramhelp.append(" ").append((String)suggestion));
                throw new BasicError(paramhelp.toString());
            }
            Object value = config.get(configkey);
            Object obj = ConfigModel.convertValueTo(this.ofType.getSimpleName(), configkey, value, element.getType());
        }
    }

    @Override
    public ConfigModel add(NBConfigModel otherModel) {
        for (Param<?> param : otherModel.getParams()) {
            this.add(param);
        }
        return this;
    }
}

