/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.config.standard;

import io.nosqlbench.nb.api.config.standard.ConfigModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;

public class ConfigSuggestions {
    public static Optional<String> getForParam(ConfigModel model, String param) {
        return ConfigSuggestions.suggestAlternateCase(model, param).or(() -> ConfigSuggestions.suggestAlternates(model, param));
    }

    private static Optional<String> suggestAlternateCase(ConfigModel model, String param) {
        for (String cname : model.getNamedParams().keySet()) {
            if (!cname.equalsIgnoreCase(param)) continue;
            return Optional.of("Did you mean '" + cname + "'?");
        }
        return Optional.empty();
    }

    private static Optional<String> suggestAlternates(ConfigModel model, String param) {
        HashMap<Integer, Set> suggestions = new HashMap<Integer, Set>();
        for (String candidate : model.getNamedParams().keySet()) {
            try {
                Integer distance = LevenshteinDistance.getDefaultInstance().apply((CharSequence)param, (CharSequence)candidate);
                Set strings = suggestions.computeIfAbsent(distance, d -> new HashSet());
                strings.add(candidate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList params = new ArrayList(suggestions.keySet());
        Collections.sort(params);
        List orderedSets = params.stream().map(suggestions::get).collect(Collectors.toList());
        if (orderedSets.size() == 0) {
            return Optional.empty();
        }
        if (((Set)orderedSets.get(0)).size() == 1) {
            return Optional.of("Did you mean '" + (String)((Set)orderedSets.get(0)).stream().findFirst().get() + "'?");
        }
        return Optional.of("Did you mean one of " + ((Set)orderedSets.get(0)).toString() + "?\n");
    }
}

