/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.content;

import io.nosqlbench.nb.api.errors.BasicError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathFinder {
    private static final Logger logger = LogManager.getLogger(PathFinder.class);

    public static Optional<Path> find(String ... names) {
        List<Path> paths = PathFinder.findAll(names);
        if (paths.size() == 0) {
            return Optional.empty();
        }
        if (paths.size() > 1) {
            throw new BasicError("Found " + paths.size() + " paths, when only one is allowed:" + paths.stream().map(p -> p.toString() + " on " + p.getFileSystem()).collect(Collectors.joining(",")));
        }
        return Optional.of(paths.get(0));
    }

    static List<Path> findAll(String ... pathspecs) {
        ArrayList<Path> founds = new ArrayList<Path>();
        for (String pathspec : pathspecs) {
            boolean wantsADirectory = pathspec.endsWith(FileSystems.getDefault().getSeparator());
            String candidatePath = wantsADirectory ? pathspec.substring(0, pathspec.length() - 1) : pathspec;
            Path candidate = Path.of(candidatePath, new String[0]);
            PathFinder.findPathOnRemoteURL(pathspec).ifPresent(founds::add);
            PathFinder.findPathOnFilesystem(candidatePath, wantsADirectory).ifPresent(founds::add);
            PathFinder.findPathOnClasspath(candidatePath, wantsADirectory).ifPresent(founds::add);
        }
        return founds;
    }

    private static Optional<Path> findPathOnRemoteURL(String pathspec) {
        Optional<InputStream> inputStreamForUrl;
        if ((pathspec.toLowerCase().startsWith("http:") || pathspec.toLowerCase().startsWith("https:")) && (inputStreamForUrl = PathFinder.getInputStreamForUrl(pathspec)).isPresent()) {
            Path found = Path.of(URI.create(pathspec));
            logger.debug("Found accessible remote file at " + found.toString());
            return Optional.of(found);
        }
        return Optional.empty();
    }

    private static Optional<Path> findPathOnClasspath(String candidatePath, boolean wantsADirectory) {
        try {
            URL url = ClassLoader.getSystemResource(candidatePath);
            if (url != null) {
                URI uri = URI.create(url.toExternalForm());
                FileSystem fileSystem = null;
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException retried) {
                    try {
                        fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                logger.debug("Found path in classpath: " + candidatePath + ": " + candidatePath);
                return Optional.of(Path.of(uri));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            logger.trace("Error while looking in classpath for " + candidatePath, (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<Path> findPathOnFilesystem(String pathName, boolean wantsADirectory) {
        try {
            Path candidatePath = Path.of(pathName, new String[0]);
            FileSystemProvider provider = candidatePath.getFileSystem().provider();
            provider.checkAccess(candidatePath, AccessMode.READ);
            BasicFileAttributes attrs = provider.readAttributes(candidatePath, BasicFileAttributes.class, new LinkOption[0]);
            boolean foundADirectory = attrs.isDirectory();
            if (wantsADirectory != foundADirectory) {
                throw new RuntimeException("for path " + candidatePath + ", user wanted a " + (wantsADirectory ? "directory" : "file") + ", but found a " + (foundADirectory ? "directory" : "file") + " while searching for " + pathName);
            }
            return Optional.of(candidatePath);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    private static Optional<InputStream> getInputStreamForUrl(String path) {
        try {
            URL url = new URL(path);
            InputStream inputStream = url.openStream();
            return Optional.ofNullable(inputStream);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

