/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.content;

import io.nosqlbench.nb.api.content.Content;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class URLContent
implements Content<URL> {
    private final URL url;
    private CharBuffer buffer;
    private InputStream inputStream;

    public URLContent(URL url, InputStream inputStream) {
        this.url = url;
        this.inputStream = inputStream;
    }

    @Override
    public URL getLocation() {
        return this.url;
    }

    @Override
    public URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLContent that = (URLContent)o;
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    @Override
    public CharBuffer getCharBuffer() {
        if (this.buffer == null) {
            InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            Stream<String> lines = bufferedReader.lines();
            String buffdata = lines.map(l -> l + "\n").collect(Collectors.joining());
            return CharBuffer.wrap(buffdata);
        }
        return this.buffer;
    }

    @Override
    public Path asPath() {
        return Paths.get(this.url.getPath(), new String[0]);
    }

    public String toString() {
        return "URLContent{" + this.getURI().toString() + "}";
    }
}

