/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.nb.api.errors;

import io.nosqlbench.nb.api.errors.ActivityInitError;

public class OpConfigError
extends ActivityInitError {
    private final String configSource;

    public OpConfigError(String error) {
        this(error, (String)null);
    }

    public OpConfigError(String error, String configSource) {
        super(error);
        this.configSource = configSource;
    }

    public OpConfigError(String error, String configSource, Throwable cause) {
        super(error, cause);
        this.configSource = configSource;
    }

    public String getCfgSrc() {
        return this.configSource;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Error while configuring op from workload template:");
        String cfgsrc = this.configSource;
        if (cfgsrc == null) {
            Throwable cause = this.getCause();
            while (cause instanceof OpConfigError && cfgsrc == null) {
                cfgsrc = ((OpConfigError)cause).getCfgSrc();
                cause = cause.getCause();
            }
        }
        if (cfgsrc != null) {
            sb.append("configsource:" + this.configSource);
        }
        if (this.getCause() != null) {
            StackTraceElement causeFrame = this.getCause().getStackTrace()[0];
            sb.append("\n\t caused by ").append(this.getCause().getMessage()).append("\n\t at (").append(causeFrame.getFileName()).append(":").append(causeFrame.getLineNumber()).append(")");
        }
        return sb + super.getMessage();
    }
}

